/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.DeleteGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;

public class UpdateTableRequestMarshaller
implements Marshaller<Request<UpdateTableRequest>, UpdateTableRequest> {
    public Request<UpdateTableRequest> marshall(UpdateTableRequest updateTableRequest) {
        if (updateTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateTableRequest, "AmazonDynamoDBv2");
        String target = "DynamoDB_20120810.UpdateTable";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag globalSecondaryIndexUpdatesList;
            ProvisionedThroughput provisionedThroughput;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag attributeDefinitionsList = (ListWithAutoConstructFlag)updateTableRequest.getAttributeDefinitions();
            if (!(attributeDefinitionsList == null || attributeDefinitionsList.isAutoConstruct() && attributeDefinitionsList.isEmpty())) {
                jsonWriter.key("AttributeDefinitions");
                jsonWriter.array();
                for (AttributeDefinition attributeDefinitionsListValue : attributeDefinitionsList) {
                    if (attributeDefinitionsListValue == null) continue;
                    jsonWriter.object();
                    if (attributeDefinitionsListValue.getAttributeName() != null) {
                        jsonWriter.key("AttributeName").value((Object)attributeDefinitionsListValue.getAttributeName());
                    }
                    if (attributeDefinitionsListValue.getAttributeType() != null) {
                        jsonWriter.key("AttributeType").value((Object)attributeDefinitionsListValue.getAttributeType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateTableRequest.getTableName() != null) {
                jsonWriter.key("TableName").value((Object)updateTableRequest.getTableName());
            }
            if ((provisionedThroughput = updateTableRequest.getProvisionedThroughput()) != null) {
                jsonWriter.key("ProvisionedThroughput");
                jsonWriter.object();
                if (provisionedThroughput.getReadCapacityUnits() != null) {
                    jsonWriter.key("ReadCapacityUnits").value((Object)provisionedThroughput.getReadCapacityUnits());
                }
                if (provisionedThroughput.getWriteCapacityUnits() != null) {
                    jsonWriter.key("WriteCapacityUnits").value((Object)provisionedThroughput.getWriteCapacityUnits());
                }
                jsonWriter.endObject();
            }
            if (!((globalSecondaryIndexUpdatesList = (ListWithAutoConstructFlag)updateTableRequest.getGlobalSecondaryIndexUpdates()) == null || globalSecondaryIndexUpdatesList.isAutoConstruct() && globalSecondaryIndexUpdatesList.isEmpty())) {
                jsonWriter.key("GlobalSecondaryIndexUpdates");
                jsonWriter.array();
                for (GlobalSecondaryIndexUpdate globalSecondaryIndexUpdatesListValue : globalSecondaryIndexUpdatesList) {
                    DeleteGlobalSecondaryIndexAction delete;
                    CreateGlobalSecondaryIndexAction create;
                    if (globalSecondaryIndexUpdatesListValue == null) continue;
                    jsonWriter.object();
                    UpdateGlobalSecondaryIndexAction update = globalSecondaryIndexUpdatesListValue.getUpdate();
                    if (update != null) {
                        ProvisionedThroughput provisionedThroughput2;
                        jsonWriter.key("Update");
                        jsonWriter.object();
                        if (update.getIndexName() != null) {
                            jsonWriter.key("IndexName").value((Object)update.getIndexName());
                        }
                        if ((provisionedThroughput2 = update.getProvisionedThroughput()) != null) {
                            jsonWriter.key("ProvisionedThroughput");
                            jsonWriter.object();
                            if (provisionedThroughput2.getReadCapacityUnits() != null) {
                                jsonWriter.key("ReadCapacityUnits").value((Object)provisionedThroughput2.getReadCapacityUnits());
                            }
                            if (provisionedThroughput2.getWriteCapacityUnits() != null) {
                                jsonWriter.key("WriteCapacityUnits").value((Object)provisionedThroughput2.getWriteCapacityUnits());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if ((create = globalSecondaryIndexUpdatesListValue.getCreate()) != null) {
                        ProvisionedThroughput provisionedThroughput3;
                        Projection projection;
                        ListWithAutoConstructFlag keySchemaList;
                        jsonWriter.key("Create");
                        jsonWriter.object();
                        if (create.getIndexName() != null) {
                            jsonWriter.key("IndexName").value((Object)create.getIndexName());
                        }
                        if (!((keySchemaList = (ListWithAutoConstructFlag)create.getKeySchema()) == null || keySchemaList.isAutoConstruct() && keySchemaList.isEmpty())) {
                            jsonWriter.key("KeySchema");
                            jsonWriter.array();
                            for (KeySchemaElement keySchemaListValue : keySchemaList) {
                                if (keySchemaListValue == null) continue;
                                jsonWriter.object();
                                if (keySchemaListValue.getAttributeName() != null) {
                                    jsonWriter.key("AttributeName").value((Object)keySchemaListValue.getAttributeName());
                                }
                                if (keySchemaListValue.getKeyType() != null) {
                                    jsonWriter.key("KeyType").value((Object)keySchemaListValue.getKeyType());
                                }
                                jsonWriter.endObject();
                            }
                            jsonWriter.endArray();
                        }
                        if ((projection = create.getProjection()) != null) {
                            ListWithAutoConstructFlag nonKeyAttributesList;
                            jsonWriter.key("Projection");
                            jsonWriter.object();
                            if (projection.getProjectionType() != null) {
                                jsonWriter.key("ProjectionType").value((Object)projection.getProjectionType());
                            }
                            if (!((nonKeyAttributesList = (ListWithAutoConstructFlag)projection.getNonKeyAttributes()) == null || nonKeyAttributesList.isAutoConstruct() && nonKeyAttributesList.isEmpty())) {
                                jsonWriter.key("NonKeyAttributes");
                                jsonWriter.array();
                                for (String nonKeyAttributesListValue : nonKeyAttributesList) {
                                    if (nonKeyAttributesListValue == null) continue;
                                    jsonWriter.value((Object)nonKeyAttributesListValue);
                                }
                                jsonWriter.endArray();
                            }
                            jsonWriter.endObject();
                        }
                        if ((provisionedThroughput3 = create.getProvisionedThroughput()) != null) {
                            jsonWriter.key("ProvisionedThroughput");
                            jsonWriter.object();
                            if (provisionedThroughput3.getReadCapacityUnits() != null) {
                                jsonWriter.key("ReadCapacityUnits").value((Object)provisionedThroughput3.getReadCapacityUnits());
                            }
                            if (provisionedThroughput3.getWriteCapacityUnits() != null) {
                                jsonWriter.key("WriteCapacityUnits").value((Object)provisionedThroughput3.getWriteCapacityUnits());
                            }
                            jsonWriter.endObject();
                        }
                        jsonWriter.endObject();
                    }
                    if ((delete = globalSecondaryIndexUpdatesListValue.getDelete()) != null) {
                        jsonWriter.key("Delete");
                        jsonWriter.object();
                        if (delete.getIndexName() != null) {
                            jsonWriter.key("IndexName").value((Object)delete.getIndexName());
                        }
                        jsonWriter.endObject();
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.0");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

