/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticfilesystem.model.DescribeTagsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeTagsRequestMarshaller
implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {
    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {
        String marker;
        String maxItems;
        if (describeTagsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTagsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-02-01/tags/{FileSystemId}/";
        uriResourcePath = uriResourcePath.replace("{FileSystemId}", describeTagsRequest.getFileSystemId() == null ? "" : StringUtils.fromString((String)describeTagsRequest.getFileSystemId()));
        request.setResourcePath(uriResourcePath);
        String string = maxItems = describeTagsRequest.getMaxItems() == null ? null : StringUtils.fromInteger((Integer)describeTagsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        String string2 = marker = describeTagsRequest.getMarker() == null ? null : StringUtils.fromString((String)describeTagsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

