/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticfilesystem.model.PerformanceMode;
import com.amazonaws.services.elasticfilesystem.model.Tag;
import com.amazonaws.services.elasticfilesystem.model.ThroughputMode;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateFileSystemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String creationToken;
    private String performanceMode;
    private Boolean encrypted;
    private String kmsKeyId;
    private String throughputMode;
    private Double provisionedThroughputInMibps;
    private SdkInternalList<Tag> tags;

    public void setCreationToken(String creationToken) {
        this.creationToken = creationToken;
    }

    public String getCreationToken() {
        return this.creationToken;
    }

    public CreateFileSystemRequest withCreationToken(String creationToken) {
        this.setCreationToken(creationToken);
        return this;
    }

    public void setPerformanceMode(String performanceMode) {
        this.performanceMode = performanceMode;
    }

    public String getPerformanceMode() {
        return this.performanceMode;
    }

    public CreateFileSystemRequest withPerformanceMode(String performanceMode) {
        this.setPerformanceMode(performanceMode);
        return this;
    }

    public void setPerformanceMode(PerformanceMode performanceMode) {
        this.withPerformanceMode(performanceMode);
    }

    public CreateFileSystemRequest withPerformanceMode(PerformanceMode performanceMode) {
        this.performanceMode = performanceMode.toString();
        return this;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public CreateFileSystemRequest withEncrypted(Boolean encrypted) {
        this.setEncrypted(encrypted);
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public CreateFileSystemRequest withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setThroughputMode(String throughputMode) {
        this.throughputMode = throughputMode;
    }

    public String getThroughputMode() {
        return this.throughputMode;
    }

    public CreateFileSystemRequest withThroughputMode(String throughputMode) {
        this.setThroughputMode(throughputMode);
        return this;
    }

    public void setThroughputMode(ThroughputMode throughputMode) {
        this.withThroughputMode(throughputMode);
    }

    public CreateFileSystemRequest withThroughputMode(ThroughputMode throughputMode) {
        this.throughputMode = throughputMode.toString();
        return this;
    }

    public void setProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
        this.provisionedThroughputInMibps = provisionedThroughputInMibps;
    }

    public Double getProvisionedThroughputInMibps() {
        return this.provisionedThroughputInMibps;
    }

    public CreateFileSystemRequest withProvisionedThroughputInMibps(Double provisionedThroughputInMibps) {
        this.setProvisionedThroughputInMibps(provisionedThroughputInMibps);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateFileSystemRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateFileSystemRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCreationToken() != null) {
            sb.append("CreationToken: ").append(this.getCreationToken()).append(",");
        }
        if (this.getPerformanceMode() != null) {
            sb.append("PerformanceMode: ").append(this.getPerformanceMode()).append(",");
        }
        if (this.getEncrypted() != null) {
            sb.append("Encrypted: ").append(this.getEncrypted()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getThroughputMode() != null) {
            sb.append("ThroughputMode: ").append(this.getThroughputMode()).append(",");
        }
        if (this.getProvisionedThroughputInMibps() != null) {
            sb.append("ProvisionedThroughputInMibps: ").append(this.getProvisionedThroughputInMibps()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFileSystemRequest)) {
            return false;
        }
        CreateFileSystemRequest other = (CreateFileSystemRequest)obj;
        if (other.getCreationToken() == null ^ this.getCreationToken() == null) {
            return false;
        }
        if (other.getCreationToken() != null && !other.getCreationToken().equals(this.getCreationToken())) {
            return false;
        }
        if (other.getPerformanceMode() == null ^ this.getPerformanceMode() == null) {
            return false;
        }
        if (other.getPerformanceMode() != null && !other.getPerformanceMode().equals(this.getPerformanceMode())) {
            return false;
        }
        if (other.getEncrypted() == null ^ this.getEncrypted() == null) {
            return false;
        }
        if (other.getEncrypted() != null && !other.getEncrypted().equals(this.getEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getThroughputMode() == null ^ this.getThroughputMode() == null) {
            return false;
        }
        if (other.getThroughputMode() != null && !other.getThroughputMode().equals(this.getThroughputMode())) {
            return false;
        }
        if (other.getProvisionedThroughputInMibps() == null ^ this.getProvisionedThroughputInMibps() == null) {
            return false;
        }
        if (other.getProvisionedThroughputInMibps() != null && !other.getProvisionedThroughputInMibps().equals(this.getProvisionedThroughputInMibps())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCreationToken() == null ? 0 : this.getCreationToken().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceMode() == null ? 0 : this.getPerformanceMode().hashCode());
        hashCode = 31 * hashCode + (this.getEncrypted() == null ? 0 : this.getEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getThroughputMode() == null ? 0 : this.getThroughputMode().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughputInMibps() == null ? 0 : this.getProvisionedThroughputInMibps().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateFileSystemRequest clone() {
        return (CreateFileSystemRequest)super.clone();
    }
}

