/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.lambda.model.EnvironmentResponse;
import com.amazonaws.services.lambda.model.transform.EnvironmentErrorJsonMarshaller;
import java.util.Map;

public class EnvironmentResponseJsonMarshaller {
    private static EnvironmentResponseJsonMarshaller instance;

    public void marshall(EnvironmentResponse environmentResponse, StructuredJsonGenerator jsonGenerator) {
        if (environmentResponse == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalMap variablesMap = (SdkInternalMap)environmentResponse.getVariables();
            if (!variablesMap.isEmpty() || !variablesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Variables");
                jsonGenerator.writeStartObject();
                for (Map.Entry variablesMapValue : variablesMap.entrySet()) {
                    if (variablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)variablesMapValue.getKey());
                    jsonGenerator.writeValue((String)variablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (environmentResponse.getError() != null) {
                jsonGenerator.writeFieldName("Error");
                EnvironmentErrorJsonMarshaller.getInstance().marshall(environmentResponse.getError(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static EnvironmentResponseJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new EnvironmentResponseJsonMarshaller();
        }
        return instance;
    }
}

