/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mediaconvert.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.mediaconvert.model.S3EncryptionSettings;

@SdkInternalApi
public class S3EncryptionSettingsMarshaller {
    private static final MarshallingInfo<String> ENCRYPTIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("encryptionType").build();
    private static final MarshallingInfo<String> KMSKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kmsKeyArn").build();
    private static final S3EncryptionSettingsMarshaller instance = new S3EncryptionSettingsMarshaller();

    public static S3EncryptionSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3EncryptionSettings s3EncryptionSettings, ProtocolMarshaller protocolMarshaller) {
        if (s3EncryptionSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3EncryptionSettings.getEncryptionType(), ENCRYPTIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)s3EncryptionSettings.getKmsKeyArn(), KMSKEYARN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

