/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.services.redshift.model.HsmStatus;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsmStatusStaxUnmarshaller
implements Unmarshaller<HsmStatus, StaxUnmarshallerContext> {
    private static HsmStatusStaxUnmarshaller instance;

    @Override
    public HsmStatus unmarshall(StaxUnmarshallerContext context) throws Exception {
        HsmStatus hsmStatus = new HsmStatus();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return hsmStatus;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("HsmClientCertificateIdentifier", targetDepth)) {
                    hsmStatus.setHsmClientCertificateIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("HsmConfigurationIdentifier", targetDepth)) {
                    hsmStatus.setHsmConfigurationIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Status", targetDepth)) continue;
                hsmStatus.setStatus(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return hsmStatus;
    }

    public static HsmStatusStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new HsmStatusStaxUnmarshaller();
        }
        return instance;
    }
}

