package com.appland.appmap.process;

/**
 * Runtime utility methods to be called from hook-generated bytecode.
 */
public class RuntimeUtil {
  /**
   * Convert a primitive byte to a Byte Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(byte value) {
    return Byte.valueOf(value);
  }

  /**
   * Convert a primitive char to a Character Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(char value) {
    return Character.valueOf(value);
  }

  /**
   * Convert a primitive short to a Short Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(short value) {
    return Short.valueOf(value);
  }

  /**
   * Convert a primitive long to a Long Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(long value) {
    return Long.valueOf(value);
  }

  /**
   * Convert a primitive float to a Float Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(float value) {
    return Float.valueOf(value);
  }

  /**
   * Convert a primitive double to a Double Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(double value) {
    return Double.valueOf(value);
  }

  /**
   * Convert a primitive int to an Integer Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(int value) {
    return Integer.valueOf(value);
  }

  /**
   * Convert a primitive boolean to a Boolean Object.
   * @param value The primitive value
   * @return The value as an Object
   */
  public static Object boxValue(boolean value) {
    return Boolean.valueOf(value);
  }

  /**
   * No-op.
   */
  public static Object boxValue(Object value) {
    return value;
  }
}
