package com.atlassian.cache;

import javax.annotation.Nonnull;

import com.atlassian.annotations.PublicApi;

/**
 * A cache listener.
 *
 * @since 2.4
 */
@PublicApi
public interface CacheEntryListener<K, V> {
    /**
     * Invoked when a key-value was added to the cache
     *
     * @param event the addition event
     */
    void onAdd(@Nonnull CacheEntryEvent<K, V> event);

    /**
     * Invoked when a key-value was evicted from the cache
     *
     * @param event the eviction event
     */
    void onEvict(@Nonnull CacheEntryEvent<K, V> event);

    /**
     * Invoked when a key-value was removed from the cache
     *
     * @param event the removal event
     */
    void onRemove(@Nonnull CacheEntryEvent<K, V> event);

    /**
     * Invoked when key-value was changed in the cache
     *
     * @param event the update event
     */
    void onUpdate(@Nonnull CacheEntryEvent<K, V> event);
}
