package com.atlassian.cache;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.atlassian.annotations.Internal;

@Internal
public interface CacheManager extends CacheFactory {
    /**
     * Gets the collection of caches managed. This collection is not a "live" collection. It is a copy.
     * @return a collection of {@link Cache}s. The returned collection will only include caches created via
     * the {@code getCache(...)} methods. Caches created via the {@code getCachedReference(...)}
     * methods are not included.
     * @deprecated Since 2.0.  Use {@link #getManagedCaches()} instead.
     */
    @Deprecated
    @Nonnull
    Collection<Cache<?, ?>> getCaches();

    /**
     * Gets the collection of caches managed. This collection is not a "live" collection. It is a copy. The
     * returned collection will include caches created via both the {@code getCache(...)} and
     * {@code getCachedReference(...)} methods.
     * @return a collection of {@link ManagedCache}s.
     */
    @Nonnull
    Collection<ManagedCache> getManagedCaches();

    /**
     * Flush the contents of all flushable caches registered with the cache manager.
     *
     * @see com.atlassian.cache.CacheSettings#getFlushable()
     */
    void flushCaches();

    /**
     * Returns the managed cache for the specified name.
     *
     * @param name the name of the managed cache to retrieve
     * @return the {@link com.atlassian.cache.ManagedCache} specified by <code>name</code>
     *         or <code>null</code> if no cache exists.
     * @since 2.3.0
     */
    @Nullable
    ManagedCache getManagedCache(@Nonnull String name);

    /**
     * Shuts down and clean all data of the current instance and its all caches.
     *
     * @since 2.4.0
     */
    void shutdown();
}
