package com.atlassian.cache;

import javax.annotation.Nonnull;

import com.atlassian.annotations.PublicSpi;

/**
 * A manager for cache settings, providing operations for retrieving and storing settings to persistent storage.
 *
 * @since 2.4.0
 */
@PublicSpi
public interface CacheSettingsDefaultsProvider {
    /**
     * Obtains the default cache settings. from persistent storage, for the specified cache.
     * @param name the name of the cache to obtain default settings
     * @return the default cache settings
     */
    @Nonnull
    CacheSettings getDefaults(@Nonnull String name);
}
