package com.atlassian.cache;

import javax.annotation.Nonnull;

import com.atlassian.annotations.PublicApi;

/**
 * A resettable reference listener.
 *
 * @since 2.4
 */
@PublicApi
public interface CachedReferenceListener<V> {
    /**
     * Invoked when the cached reference was evicted
     *
     * @param event the eviction event
     */
    void onEvict(@Nonnull CachedReferenceEvent<V> event);

    /**
     * Invoked when the cached reference was set, e.g. received a new value
     *
     * @param event the set event
     */
    void onSet(@Nonnull CachedReferenceEvent<V> event);

    /**
     * Invoked when the cached reference was reset
     *
     * @param event the reset event
     */
    void onReset(@Nonnull CachedReferenceEvent<V> event);
}
