package com.atlassian.cache.impl;

import com.atlassian.cache.CacheEntryListener;

/**
 * This interface is designed to support {@code Cache} implementations in working with {@code CacheEntryListener}s.
 * <p>
 * The main usage pattern for which this is designed is to use delegation for add/remove (therefore the listeners are
 * managed by the this interface) and then use notify* methods to create and deliver the actual events.
 */
public interface CacheEntryListenerSupport<K, V> {
    void add(CacheEntryListener<K, V> listener, boolean includeValues);

    void remove(CacheEntryListener<K, V> listener);

    void notifyAdd(K key, V value);

    void notifyEvict(K key, V oldValue);

    void notifyRemove(K key, V oldValue);

    void notifyUpdate(K key, V value, V oldValue);

    CacheEntryListenerSupport EMPTY = new CacheEntryListenerSupport() {
        @Override
        public void add(CacheEntryListener listener, boolean includeValues) {}

        @Override
        public void remove(CacheEntryListener listener) {}

        @Override
        public void notifyAdd(Object key, Object value) {}

        @Override
        public void notifyEvict(Object key, Object oldValue) {}

        @Override
        public void notifyRemove(Object key, Object oldValue) {}

        @Override
        public void notifyUpdate(Object key, Object value, Object oldValue) {}
    };
}
