package com.atlassian.cache.impl;

import java.util.function.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;

public class CacheEntryNotificationSupport {
    private static final Logger log = LoggerFactory.getLogger(CacheEntryNotificationSupport.class);

    private static final CacheEntryNotificationSupport INSTANCE = new CacheEntryNotificationSupport();

    public static CacheEntryNotificationSupport getInstance() {
        return INSTANCE;
    }

    public <K, V> void notifyAdd(Iterable<CacheEntryListener<K, V>> listeners, final CacheEntryEvent<K, V> event) {
        notify(listeners, listener -> listener.onAdd(event));
    }

    public <K, V> void notifyEvict(Iterable<CacheEntryListener<K, V>> listeners, final CacheEntryEvent<K, V> event) {
        notify(listeners, listener -> listener.onEvict(event));
    }

    public <K, V> void notifyRemove(Iterable<CacheEntryListener<K, V>> listeners, final CacheEntryEvent<K, V> event) {
        notify(listeners, listener -> listener.onRemove(event));
    }

    public <K, V> void notifyUpdate(Iterable<CacheEntryListener<K, V>> listeners, final CacheEntryEvent<K, V> event) {
        notify(listeners, listener -> listener.onUpdate(event));
    }

    public <K, V> void notify(Iterable<CacheEntryListener<K, V>> listeners, Consumer<CacheEntryListener<K, V>> effect) {
        listeners.forEach(listener -> {
            try {
                effect.accept(listener);
            } catch (RuntimeException exc) {
                log.error("Exception while notifying listeners", exc);
            }
        });
    }
}
