package com.atlassian.cache.impl;

import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.Supplier;

/**
 * @since 2.5
 */
public class CacheLoaderSupplier<K, V> implements Supplier<V> {

    private final K key;
    private final CacheLoader<? super K, ? extends V> loader;

    public CacheLoaderSupplier(final K key, final CacheLoader<? super K, ? extends V> loader) {
        this.key = key;
        this.loader = loader;
    }

    @Override
    public V get() {
        return loader.load(key);
    }
}
