package com.atlassian.cache.impl;

import io.atlassian.util.concurrent.LazyReference;

import com.atlassian.cache.CacheEntryListener;

public class ValueCacheEntryListenerSupport<K, V> implements CacheEntryListenerSupport<K, V> {
    private final LazyReference<Void> initReference = new LazyReference<Void>() {
        @Override
        protected Void create() throws Exception {
            init(ValueCacheEntryListenerSupport.this);
            return null;
        }
    };

    private final CacheEntryListenerSupport<K, V> valueListenerSupport = new LazyCacheEntryListenerSupport<K, V>() {
        @Override
        protected void init() {
            initReference.get();
            initValue(this);
        }
    };

    private final CacheEntryListenerSupport<K, V> valuelessListenerSupport = new LazyCacheEntryListenerSupport<K, V>() {
        @Override
        protected void init() {
            initReference.get();
            initValueless(this);
        }
    };

    protected void init(CacheEntryListenerSupport<K, V> actualListenerSupport) {}

    protected void initValue(CacheEntryListenerSupport<K, V> actualListenerSupport) {}

    protected void initValueless(CacheEntryListenerSupport<K, V> actualListenerSupport) {}

    @Override
    public void add(final CacheEntryListener<K, V> listener, final boolean includeValues) {
        if (includeValues) {
            valueListenerSupport.add(listener, true);
        } else {
            valuelessListenerSupport.add(listener, false);
        }
    }

    @Override
    public void remove(final CacheEntryListener<K, V> listener) {
        valueListenerSupport.remove(listener);
        valuelessListenerSupport.remove(listener);
    }

    @Override
    public void notifyAdd(final K key, final V value) {
        valueListenerSupport.notifyAdd(key, value);
        valuelessListenerSupport.notifyAdd(key, null);
    }

    @Override
    public void notifyEvict(final K key, final V oldValue) {
        valueListenerSupport.notifyEvict(key, oldValue);
        valuelessListenerSupport.notifyEvict(key, null);
    }

    @Override
    public void notifyRemove(final K key, final V oldValue) {
        valueListenerSupport.notifyRemove(key, oldValue);
        valuelessListenerSupport.notifyRemove(key, null);
    }

    @Override
    public void notifyUpdate(final K key, final V value, final V oldValue) {
        valueListenerSupport.notifyUpdate(key, value, oldValue);
        valuelessListenerSupport.notifyUpdate(key, null, null);
    }
}
