package com.atlassian.cache.ehcache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Status;
import net.sf.ehcache.loader.CacheLoader;

import com.atlassian.cache.Supplier;
import com.atlassian.cache.impl.ReferenceKey;

/**
 *  A delegating loader for EhCache.
 *
 * @since v2.0.8
 */
class ReferenceCacheLoader<V> implements CacheLoader, Cloneable {
    private Supplier<V> supplier;

    public ReferenceCacheLoader(final Supplier<V> supplier) {
        this.supplier = supplier;
    }

    @Override
    public Object load(final Object key) {
        return supplier.get();
    }

    @Override
    public Map loadAll(final Collection keys) {
        Map<ReferenceKey, V> map = new HashMap<ReferenceKey, V>();
        for (Object key : keys) {
            final V value = supplier.get();
            if (value != null) {
                map.put(ReferenceKey.KEY, value);
            }
        }
        return map;
    }

    @Override
    public Object load(final Object key, final Object argument) {
        return load(key);
    }

    @Override
    public Map loadAll(final Collection keys, final Object argument) {
        return loadAll(keys);
    }

    @Override
    public String getName() {
        return supplier.getClass().getName();
    }

    @Override
    public CacheLoader clone(final Ehcache cache) throws CloneNotSupportedException {
        return (CacheLoader) super.clone();
    }

    @Override
    public void init() {}

    @Override
    public void dispose() throws net.sf.ehcache.CacheException {
        supplier = null;
    }

    @Override
    public Status getStatus() {
        return supplier == null ? Status.STATUS_ALIVE : Status.STATUS_UNINITIALISED;
    }
}
