package com.atlassian.cache.ehcache.replication;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.atlassian.cache.CacheSettings;

import static net.sf.ehcache.config.CacheConfiguration.CacheEventListenerFactoryConfiguration;

/**
 * Provides operations for creating cache replicator configurations.
 *
 * @since 2.6.0
 */
@ParametersAreNonnullByDefault
public interface EhCacheReplicatorConfigFactory {
    /**
     * Create an EhCache {@link CacheEventListenerFactoryConfiguration} which defines the cache replicator for the given
     * cache settings.
     */
    @Nonnull
    CacheEventListenerFactoryConfiguration createCacheReplicatorConfiguration(
            CacheSettings settings, boolean selfLoadingCache);
}
