package com.atlassian.cache.ehcache.wrapper;

import javax.annotation.Nonnull;

import net.sf.ehcache.CacheException;

import com.atlassian.cache.CacheLoader;

/**
 * Decorates the loader of {@link com.atlassian.cache.ehcache.LoadingCache}.
 * We make sure that during the loading operation, wrapped key does not leak to the end user.
 */
public class ValueProcessorAtlassianCacheLoaderDecorator implements CacheLoader<Object, Object> {

    private final CacheLoader delegate;
    private final ValueProcessor valueProcessor;

    public ValueProcessorAtlassianCacheLoaderDecorator(
            final CacheLoader delegate, final ValueProcessor valueProcessor) {
        this.delegate = delegate;
        this.valueProcessor = valueProcessor;
    }

    @SuppressWarnings("unchecked")
    @Override
    @Nonnull
    public Object load(@Nonnull final Object key) throws CacheException {
        return valueProcessor.wrap(delegate.load(valueProcessor.unwrap(key)));
    }
}
