/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.marketplace.client.MarketplaceClient;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.http.HttpConfiguration;
import com.atlassian.marketplace.client.http.HttpTransport;
import com.atlassian.marketplace.client.http.RequestDecorator;
import com.atlassian.marketplace.client.http.SimpleHttpResponse;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecChainHandler;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.cache.CacheConfig;
import org.apache.hc.client5.http.impl.cache.CachingHttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.InputStreamEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public final class CommonsHttpTransport
implements HttpTransport {
    private static final Logger logger = LoggerFactory.getLogger(MarketplaceClient.class);
    private static final ContentType APPLICATION_JSON_PATCH = ContentType.create((String)"application/json-patch+json", (Charset)StandardCharsets.UTF_8);
    private final CloseableHttpClient client;
    private final HttpConfiguration config;
    private final HttpTransport defaultOperations;

    public CommonsHttpTransport(HttpConfiguration configuration, URI baseUri) {
        this.config = (HttpConfiguration)Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        this.client = CommonsHttpTransport.httpClientBuilder(this.config, (Option<URI>)Option.some((Object)baseUri), CachingBehavior.CACHING).build();
        this.defaultOperations = new OperationsImpl((Iterable<RequestDecorator>)ImmutableList.of());
    }

    @Override
    public SimpleHttpResponse get(URI uri) throws MpacException {
        return this.defaultOperations.get(uri);
    }

    @Override
    public SimpleHttpResponse postParams(URI uri, Map<String, List<String>> params) throws MpacException {
        return this.defaultOperations.postParams(uri, params);
    }

    @Override
    public SimpleHttpResponse post(URI uri, InputStream content, long length, String contentType, String acceptContentType, Optional<Consumer<HttpPost>> modifyRequest) throws MpacException {
        return this.defaultOperations.post(uri, content, length, contentType, acceptContentType, modifyRequest);
    }

    @Override
    public SimpleHttpResponse put(URI uri, byte[] content) throws MpacException {
        return this.defaultOperations.put(uri, content);
    }

    @Override
    public SimpleHttpResponse patch(URI uri, byte[] content) throws MpacException {
        return this.defaultOperations.patch(uri, content);
    }

    @Override
    public SimpleHttpResponse delete(URI uri) throws MpacException {
        return this.defaultOperations.delete(uri);
    }

    @Override
    public HttpTransport withRequestDecorator(RequestDecorator decorator) {
        return this.defaultOperations.withRequestDecorator(decorator);
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                logger.warn("Unexpected error while closing HTTP client: " + e);
                logger.debug(e.toString(), (Throwable)e);
            }
        }
    }

    public static HttpClient createHttpClient(HttpConfiguration config, Option<URI> baseUri) {
        return CommonsHttpTransport.httpClientBuilder(config, baseUri, CachingBehavior.NO_CACHING).build();
    }

    public static HttpClientBuilder httpClientBuilder(HttpConfiguration config, Option<URI> baseUri, CachingBehavior cachingBehavior) {
        HttpClientBuilder builder;
        if (cachingBehavior == CachingBehavior.CACHING) {
            CachingHttpClientBuilder cachingBuilder = CachingHttpClientBuilder.create();
            CacheConfig.Builder configBuilder = CacheConfig.custom();
            configBuilder.setSharedCache(false);
            configBuilder.setMaxCacheEntries(config.getMaxCacheEntries());
            configBuilder.setMaxObjectSize(config.getMaxCacheObjectSize());
            cachingBuilder.setCacheConfig(configBuilder.build());
            builder = cachingBuilder;
        } else {
            builder = HttpClientBuilder.create();
        }
        builder.useSystemProperties();
        Timeout readTimeout = Timeout.ofMilliseconds((long)config.getReadTimeoutMillis());
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnPerRoute(config.getMaxConnections()).setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)config.getConnectTimeoutMillis())).setSocketTimeout(readTimeout).build()).build();
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        RequestConfig.Builder rc = RequestConfig.custom().setResponseTimeout(readTimeout).setCookieSpec("ignore").setProxyPreferredAuthSchemes(CommonsHttpTransport.getProxyPreferredAuthSchemes(config));
        Iterator iterator = config.getMaxRedirects().iterator();
        while (iterator.hasNext()) {
            int maxRedirects = (Integer)iterator.next();
            rc.setMaxRedirects(maxRedirects);
        }
        builder.setDefaultRequestConfig(rc.build());
        Option<HttpConfiguration.ProxyHost> realProxyHost = CommonsHttpTransport.getRealProxyHost(config, baseUri);
        for (HttpConfiguration.ProxyHost ph : realProxyHost) {
            builder.setProxy(new HttpHost(ph.getHostname(), ph.getPort()));
        }
        DefaultCredentialsProvider defaultCredentialsProvider = new DefaultCredentialsProvider(config, realProxyHost);
        builder.addExecInterceptorFirst("DefaultExecChainHandler", (ExecChainHandler)new DefaultExecChainHandler(config, realProxyHost, defaultCredentialsProvider));
        builder.setDefaultCredentialsProvider((CredentialsProvider)defaultCredentialsProvider);
        return builder;
    }

    private static Option<HttpConfiguration.ProxyHost> getRealProxyHost(HttpConfiguration config, Option<URI> baseUri) {
        for (HttpConfiguration.ProxyConfiguration proxy : config.getProxyConfiguration()) {
            if (proxy.getProxyHost().isDefined()) {
                return proxy.getProxyHost();
            }
            String prefix = "https";
            for (URI u : baseUri) {
                if (u.getScheme() == null || !u.getScheme().equalsIgnoreCase("http")) continue;
                prefix = "http";
            }
            Iterator iterator = Option.option((Object)StringUtils.trimToNull((String)System.getProperty(prefix + ".proxyHost"))).iterator();
            if (!iterator.hasNext()) continue;
            String host = (String)iterator.next();
            int port = Integer.parseInt(System.getProperty(prefix + ".proxyPort", String.valueOf(80)));
            return Option.some((Object)new HttpConfiguration.ProxyHost(host, port));
        }
        return Option.none();
    }

    private static ImmutableList<String> getProxyPreferredAuthSchemes(HttpConfiguration config) {
        for (HttpConfiguration.ProxyConfiguration proxy : config.getProxyConfiguration()) {
            Iterator iterator = proxy.getAuthParams().iterator();
            if (!iterator.hasNext()) continue;
            HttpConfiguration.ProxyAuthParams auth = (HttpConfiguration.ProxyAuthParams)iterator.next();
            return ImmutableList.of((Object)auth.getAuthMethod().name().toUpperCase());
        }
        return ImmutableList.of();
    }

    public static enum CachingBehavior {
        NO_CACHING,
        CACHING;

    }

    private class OperationsImpl
    implements HttpTransport {
        private final Iterable<RequestDecorator> decorators;

        OperationsImpl(Iterable<RequestDecorator> decorators) {
            this.decorators = ImmutableList.copyOf(decorators);
        }

        @Override
        public HttpTransport withRequestDecorator(RequestDecorator decorator) {
            return new OperationsImpl(Iterables.concat(this.decorators, (Iterable)ImmutableList.of((Object)decorator)));
        }

        @Override
        public SimpleHttpResponse get(URI uri) throws MpacException {
            HttpGet method = new HttpGet(uri);
            return this.executeMethod((HttpUriRequest)method);
        }

        @Override
        public SimpleHttpResponse postParams(URI uri, Map<String, List<String>> params) throws MpacException {
            HttpPost method = new HttpPost(uri);
            ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, List<String>> param : params.entrySet()) {
                for (String s : param.getValue()) {
                    formParams.add(new BasicNameValuePair(param.getKey(), s));
                }
            }
            method.setEntity((HttpEntity)new UrlEncodedFormEntity(formParams));
            return this.executeMethod((HttpUriRequest)method);
        }

        @Override
        public SimpleHttpResponse post(URI uri, InputStream content, long length, String contentType, String acceptContentType, Optional<Consumer<HttpPost>> modifyRequest) throws MpacException {
            HttpPost httpPost = new HttpPost(uri);
            httpPost.setEntity((HttpEntity)new InputStreamEntity(content, length, ContentType.create((String)contentType, (Charset)StandardCharsets.UTF_8)));
            httpPost.addHeader("Content-Type", (Object)contentType.concat("; charset=UTF-8"));
            httpPost.addHeader("Accept", (Object)acceptContentType);
            modifyRequest.ifPresent(c -> c.accept(httpPost));
            return this.executeMethod((HttpUriRequest)httpPost);
        }

        @Override
        public SimpleHttpResponse put(URI uri, byte[] content) throws MpacException {
            HttpPut method = new HttpPut(uri);
            method.setEntity((HttpEntity)new ByteArrayEntity(content, ContentType.APPLICATION_JSON));
            return this.executeMethod((HttpUriRequest)method);
        }

        @Override
        public SimpleHttpResponse patch(URI uri, byte[] content) throws MpacException {
            HttpPatch method = new HttpPatch(uri);
            method.setEntity((HttpEntity)new ByteArrayEntity(content, APPLICATION_JSON_PATCH));
            return this.executeMethod((HttpUriRequest)method);
        }

        @Override
        public SimpleHttpResponse delete(URI uri) throws MpacException {
            HttpDelete method = new HttpDelete(uri);
            return this.executeMethod((HttpUriRequest)method);
        }

        @Override
        public void close() {
            CommonsHttpTransport.this.close();
        }

        private SimpleHttpResponse executeMethod(HttpUriRequest method) throws MpacException {
            logger.info(method.getMethod() + " " + method.getRequestUri());
            for (RequestDecorator rd : this.decorators) {
                Map<String, String> moreHeaders = rd.getRequestHeaders();
                if (moreHeaders == null) continue;
                for (Map.Entry<String, String> header : moreHeaders.entrySet()) {
                    method.addHeader(header.getKey(), (Object)header.getValue());
                }
            }
            try {
                return new ResponseImpl((ClassicHttpResponse)CommonsHttpTransport.this.client.execute((ClassicHttpRequest)method));
            }
            catch (SocketException e) {
                throw new MpacException.ConnectionFailure(e);
            }
            catch (IOException e) {
                throw new MpacException(e);
            }
        }
    }

    private static class DefaultCredentialsProvider
    implements CredentialsProvider {
        private final Option<HttpConfiguration.ProxyHost> proxyHost;
        private final Option<Credentials> proxyCredentials;
        private final Option<Credentials> targetHostCredentials;

        DefaultCredentialsProvider(HttpConfiguration config, Option<HttpConfiguration.ProxyHost> proxyHost) {
            this.proxyCredentials = this.makeProxyCredentials(config);
            this.targetHostCredentials = this.makeTargetHostCredentials(config);
            this.proxyHost = (Option)Preconditions.checkNotNull(proxyHost);
        }

        public Credentials getCredentials(AuthScope authScope, HttpContext context) {
            for (HttpConfiguration.ProxyHost ph : this.proxyHost) {
                if (!ph.getHostname().equals(authScope.getHost()) || ph.getPort() != authScope.getPort()) continue;
                return (Credentials)this.proxyCredentials.getOrElse((Object)null);
            }
            return (Credentials)this.targetHostCredentials.getOrElse((Object)null);
        }

        private Option<Credentials> makeProxyCredentials(HttpConfiguration config) {
            for (HttpConfiguration.ProxyConfiguration proxy : config.getProxyConfiguration()) {
                UsernamePasswordCredentials c;
                Iterator iterator = proxy.getAuthParams().iterator();
                if (!iterator.hasNext()) continue;
                HttpConfiguration.ProxyAuthParams auth = (HttpConfiguration.ProxyAuthParams)iterator.next();
                switch (auth.getAuthMethod()) {
                    case NTLM: {
                        c = new NTCredentials(auth.getCredentials().getUsername(), auth.getCredentials().getPassword().toCharArray(), (String)auth.getNtlmWorkstation().getOrElse((Object)""), (String)auth.getNtlmDomain().getOrElse((Object)""));
                        break;
                    }
                    default: {
                        c = new UsernamePasswordCredentials(auth.getCredentials().getUsername(), auth.getCredentials().getPassword().toCharArray());
                    }
                }
                return Option.some((Object)c);
            }
            return Option.none();
        }

        private Option<Credentials> makeTargetHostCredentials(HttpConfiguration config) {
            Iterator iterator = config.getCredentials().iterator();
            if (iterator.hasNext()) {
                HttpConfiguration.Credentials c = (HttpConfiguration.Credentials)iterator.next();
                return Option.some((Object)new UsernamePasswordCredentials(c.getUsername(), c.getPassword().toCharArray()));
            }
            return Option.none();
        }
    }

    private static class DefaultExecChainHandler
    implements ExecChainHandler {
        private final HttpConfiguration config;
        private final Option<HttpConfiguration.ProxyHost> proxyHost;
        private final CredentialsProvider credentialsProvider;

        DefaultExecChainHandler(HttpConfiguration config, Option<HttpConfiguration.ProxyHost> proxyHost, CredentialsProvider credentialsProvider) {
            this.config = (HttpConfiguration)Preconditions.checkNotNull((Object)config);
            this.proxyHost = (Option)Preconditions.checkNotNull(proxyHost);
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider);
        }

        public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
            BasicAuthCache authCache = null;
            for (RequestDecorator rd : this.config.getRequestDecorator()) {
                Map<String, String> headers = rd.getRequestHeaders();
                if (headers == null) continue;
                for (Map.Entry<String, String> header : headers.entrySet()) {
                    request.addHeader(header.getKey(), (Object)header.getValue());
                }
            }
            if (this.config.hasCredentials()) {
                authCache = new BasicAuthCache();
                try {
                    HttpHost targetHost = URIUtils.extractHost((URI)request.getUri());
                    if (targetHost != null) {
                        BasicScheme authScheme = new BasicScheme();
                        HttpConfiguration.Credentials credentials = (HttpConfiguration.Credentials)this.config.getCredentials().get();
                        authScheme.initPreemptive((Credentials)new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword().toCharArray()));
                        authCache.put(targetHost, (AuthScheme)authScheme);
                    }
                }
                catch (Exception e) {
                    logger.warn("Error, unable to set BasicScheme for target host", (Throwable)e);
                    logger.debug(e.toString(), (Throwable)e);
                }
            }
            for (HttpConfiguration.ProxyConfiguration proxy : this.config.getProxyConfiguration()) {
                for (HttpConfiguration.ProxyAuthParams auth : proxy.getAuthParams()) {
                    if (auth.getAuthMethod() != HttpConfiguration.ProxyAuthMethod.BASIC) continue;
                    for (HttpConfiguration.ProxyHost ph : this.proxyHost) {
                        HttpHost hph = new HttpHost(ph.getHostname(), ph.getPort());
                        Credentials credentials = this.credentialsProvider.getCredentials(new AuthScope(hph), null);
                        if (!(credentials instanceof UsernamePasswordCredentials)) continue;
                        if (authCache == null) {
                            authCache = new BasicAuthCache();
                        }
                        BasicScheme proxyAuth = new BasicScheme();
                        try {
                            proxyAuth.initPreemptive(credentials);
                            authCache.put(hph, (AuthScheme)proxyAuth);
                        }
                        catch (Exception e) {
                            logger.warn("Error, unable to set preemptive proxy auth: " + e);
                            logger.debug(e.toString(), (Throwable)e);
                        }
                    }
                }
            }
            if (authCache != null) {
                scope.clientContext.setAuthCache((AuthCache)authCache);
            }
            return chain.proceed(request, scope);
        }
    }

    private static class ResponseImpl
    implements SimpleHttpResponse {
        private final ClassicHttpResponse response;

        ResponseImpl(ClassicHttpResponse response) {
            this.response = response;
        }

        @Override
        public int getStatus() {
            return this.response.getCode();
        }

        @Override
        public Iterable<String> getHeader(String name) {
            ImmutableList.Builder ret = ImmutableList.builder();
            for (Header h : this.response.getHeaders(name)) {
                ret.add((Object)h.getValue());
            }
            return ret.build();
        }

        @Override
        public InputStream getContentStream() throws MpacException {
            try {
                return this.response.getEntity().getContent();
            }
            catch (IOException e) {
                throw new MpacException(e);
            }
        }

        @Override
        public boolean isEmpty() {
            Header h = this.response.getFirstHeader("Content-Length");
            return h != null && h.getValue().trim().equals("0");
        }

        @Override
        public void close() {
            if (this.response.getEntity() != null) {
                EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            }
        }
    }
}

