/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.ReferenceMode;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.internal.parsers.XmlDescriptorParserUtils;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.factory.OsgiChainedModuleDescriptorFactoryCreator;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.osgi.factory.OsgiPluginXmlDescriptorParserFactory;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformer;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.osgi.internal.factory.transform.DefaultPluginTransformer;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.parsers.CompositeDescriptorParserFactory;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiPluginFactory
extends AbstractPluginFactory {
    private static final Logger log = LoggerFactory.getLogger(OsgiPluginFactory.class);
    private static final Predicate<Integer> IS_PLUGINS_2 = input -> input != null && input == 2;
    public static final String TRANSFORMERLESS_DOC_URL = "https://developer.atlassian.com/server/framework/atlassian-sdk/transformerless-plugin-conversion";
    public static final String PLUGIN_TRANSFORMATION_DISABLED_PROP = "atlassian.plugin.osgi.transformation.disabled";
    private final boolean isPluginTransformationDisabled = Boolean.getBoolean("atlassian.plugin.osgi.transformation.disabled");
    private final OsgiContainerManager osgi;
    private final String pluginDescriptorFileName;
    private final PluginEventManager pluginEventManager;
    private final Set<Application> applications;
    private final OsgiPersistentCache persistentCache;
    private final PluginTransformerFactory pluginTransformerFactory;
    private volatile PluginTransformer pluginTransformer;
    private final OsgiChainedModuleDescriptorFactoryCreator osgiChainedModuleDescriptorFactoryCreator;

    public OsgiPluginFactory(String pluginDescriptorFileName, Set<Application> applications, OsgiPersistentCache persistentCache, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this(pluginDescriptorFileName, applications, persistentCache, osgi, pluginEventManager, new DefaultPluginTransformerFactory());
    }

    public OsgiPluginFactory(String pluginDescriptorFileName, Set<Application> applications, OsgiPersistentCache persistentCache, OsgiContainerManager osgi, PluginEventManager pluginEventManager, PluginTransformerFactory pluginTransformerFactory) {
        super((DescriptorParserFactory)new OsgiPluginXmlDescriptorParserFactory(), applications);
        this.pluginDescriptorFileName = Objects.requireNonNull(pluginDescriptorFileName, "Plugin descriptor is required");
        this.osgi = Objects.requireNonNull(osgi, "The OSGi container is required");
        this.applications = Objects.requireNonNull(applications, "Applications is required!");
        this.persistentCache = Objects.requireNonNull(persistentCache, "The osgi persistent cache is required");
        this.pluginEventManager = Objects.requireNonNull(pluginEventManager, "The plugin event manager is required");
        this.pluginTransformerFactory = Objects.requireNonNull(pluginTransformerFactory, "The plugin transformer factory is required");
        this.osgiChainedModuleDescriptorFactoryCreator = new OsgiChainedModuleDescriptorFactoryCreator(osgi::getServiceTracker);
    }

    private PluginTransformer getPluginTransformer() {
        if (this.pluginTransformer == null) {
            String exportString = (String)this.osgi.getBundles()[0].getHeaders().get("Export-Package");
            SystemExports exports = new SystemExports(exportString);
            this.pluginTransformer = this.pluginTransformerFactory.newPluginTransformer(this.persistentCache, exports, this.applications, this.pluginDescriptorFileName, this.osgi);
        }
        return this.pluginTransformer;
    }

    public String canCreate(PluginArtifact pluginArtifact) {
        boolean isPlugin = this.hasDescriptor(Objects.requireNonNull(pluginArtifact));
        boolean hasSpring = pluginArtifact.containsSpringContext();
        boolean isTransformless = this.getPluginKeyFromManifest(Objects.requireNonNull(pluginArtifact)) != null;
        String key = null;
        if (isPlugin && !isTransformless || isTransformless && hasSpring) {
            key = isPlugin ? this.getPluginKeyFromDescriptor(Objects.requireNonNull(pluginArtifact)) : this.getPluginKeyFromManifest(pluginArtifact);
        }
        return key;
    }

    protected InputStream getDescriptorInputStream(PluginArtifact pluginArtifact) {
        return pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
    }

    protected Predicate<Integer> isValidPluginsVersion() {
        return IS_PLUGINS_2;
    }

    private String getPluginKeyFromManifest(PluginArtifact pluginArtifact) {
        Manifest mf = OsgiHeaderUtil.getManifest(pluginArtifact);
        if (mf != null) {
            String key = mf.getMainAttributes().getValue("Atlassian-Plugin-Key");
            String version = mf.getMainAttributes().getValue("Bundle-Version");
            if (key != null) {
                if (version != null) {
                    return key;
                }
                log.warn("Found plugin key '{}' in the manifest but no bundle version, so it can't be loaded as an OsgiPlugin", (Object)key);
            }
        }
        return null;
    }

    private Iterable<String> getScanFoldersFromManifest(PluginArtifact pluginArtifact) {
        String sf;
        HashSet scanFolders = Sets.newHashSet();
        Manifest mf = OsgiHeaderUtil.getManifest(pluginArtifact);
        if (mf != null && StringUtils.isNotBlank((CharSequence)(sf = mf.getMainAttributes().getValue("Atlassian-Scan-Folders")))) {
            String[] folders = sf.split(",");
            scanFolders.addAll(Arrays.asList(folders));
        }
        return scanFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) {
        block7: {
            block6: {
                Objects.requireNonNull(pluginArtifact, "The plugin deployment unit is required");
                Objects.requireNonNull(moduleDescriptorFactory, "The module descriptor factory is required");
                pluginDescriptor = null;
                pluginDescriptor = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
                if (pluginDescriptor == null) ** GOTO lbl30
                combinedFactory = this.getChainedModuleDescriptorFactory(moduleDescriptorFactory, pluginArtifact);
                pluginKeyFromManifest = this.getPluginKeyFromManifest(pluginArtifact);
                if (pluginKeyFromManifest != null) ** GOTO lbl23
                if (!this.isPluginTransformationDisabled) break block6;
                OsgiPluginFactory.log.warn("Unable to load plugin '{}' as it requires transformation, which is no longer supported. Developers should refer to: {}", (Object)pluginArtifact.getName(), (Object)"https://developer.atlassian.com/server/framework/atlassian-sdk/transformerless-plugin-conversion");
                var8_8 = new UnloadablePlugin(pluginArtifact.getName() + " requires transformation, which is not supported.");
                IOUtils.closeQuietly((InputStream)pluginDescriptor);
                return var8_8;
            }
            try {
                block8: {
                    OsgiPluginFactory.log.warn("Plugin '{}' requires transformation. Plugin transformation is deprecated and will be removed in the next major product release. Developers should refer to: {}", (Object)pluginArtifact.getName(), (Object)"https://developer.atlassian.com/server/framework/atlassian-sdk/transformerless-plugin-conversion");
                    OsgiPluginFactory.log.debug("Plugin key NOT found in manifest at entry {}, undergoing transformation", (Object)"Atlassian-Plugin-Key");
                    artifactToInstall = this.createOsgiPluginJar(pluginArtifact);
                    break block8;
lbl23:
                    // 1 sources

                    OsgiPluginFactory.log.debug("Plugin key found in manifest at entry {}, skipping transformation for '{}'", (Object)"Atlassian-Plugin-Key", (Object)pluginKeyFromManifest);
                    artifactToInstall = pluginArtifact;
                }
                parser = this.createDescriptorParser(artifactToInstall, pluginDescriptor);
                osgiPlugin = new OsgiPlugin(parser.getKey(), this.osgi, artifactToInstall, pluginArtifact, this.pluginEventManager);
                plugin = parser.configurePlugin(combinedFactory, (Plugin)osgiPlugin);
                break block7;
lbl30:
                // 1 sources

                manifest = OsgiHeaderUtil.getManifest(pluginArtifact);
                if (manifest != null) {
                    plugin = OsgiPluginFactory.extractOsgiPlugin(pluginArtifact, manifest, this.osgi, this.pluginEventManager);
                    plugin.setPluginInformation(OsgiHeaderUtil.extractOsgiPluginInformation(manifest, true));
                    break block7;
                }
                OsgiPluginFactory.log.warn("Unable to load plugin from '{}', no manifest", (Object)pluginArtifact);
                var6_11 = new UnloadablePlugin("No manifest in PluginArtifact '" + String.valueOf(pluginArtifact) + "'");
            }
            catch (PluginTransformationException ex) {
                try {
                    var6_12 = this.reportUnloadablePlugin(pluginArtifact.toFile(), ex);
                }
                catch (Throwable var10_15) {
                    IOUtils.closeQuietly(pluginDescriptor);
                    throw var10_15;
                }
                IOUtils.closeQuietly((InputStream)pluginDescriptor);
                return var6_12;
            }
            IOUtils.closeQuietly((InputStream)pluginDescriptor);
            return var6_11;
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    public ModuleDescriptor<?> createModule(Plugin plugin, Element module, ModuleDescriptorFactory moduleDescriptorFactory) {
        if (plugin instanceof OsgiPlugin) {
            ModuleDescriptorFactory combinedFactory = this.osgiChainedModuleDescriptorFactoryCreator.create((String name) -> false, moduleDescriptorFactory);
            return XmlDescriptorParserUtils.addModule((ModuleDescriptorFactory)combinedFactory, (Plugin)plugin, (Element)module);
        }
        return null;
    }

    private DescriptorParser createDescriptorParser(PluginArtifact pluginArtifact, InputStream pluginDescriptor) {
        HashSet xmlPaths = Sets.newHashSet();
        for (String path : this.getScanFoldersFromManifest(pluginArtifact)) {
            xmlPaths.addAll(((PluginArtifact.HasExtraModuleDescriptors)pluginArtifact).extraModuleDescriptorFiles(path));
        }
        Iterable sources = Iterables.transform((Iterable)xmlPaths, arg_0 -> ((PluginArtifact)pluginArtifact).getResourceAsStream(arg_0));
        return ((CompositeDescriptorParserFactory)this.descriptorParserFactory).getInstance(pluginDescriptor, sources, this.applications);
    }

    private static Plugin extractOsgiPlugin(PluginArtifact pluginArtifact, Manifest mf, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        String pluginKey = OsgiHeaderUtil.getNonEmptyAttribute(mf, "Atlassian-Plugin-Key");
        String bundleName = OsgiHeaderUtil.getAttributeWithoutValidation(mf, "Bundle-Name");
        OsgiPlugin plugin = new OsgiPlugin(pluginKey, osgi, pluginArtifact, pluginArtifact, pluginEventManager);
        plugin.setPluginsVersion(2);
        plugin.setName(bundleName);
        return plugin;
    }

    private ModuleDescriptorFactory getChainedModuleDescriptorFactory(ModuleDescriptorFactory originalFactory, PluginArtifact pluginArtifact) {
        return this.osgiChainedModuleDescriptorFactoryCreator.create(arg_0 -> ((PluginArtifact)pluginArtifact).doesResourceExist(arg_0), originalFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginArtifact createOsgiPluginJar(PluginArtifact pluginArtifact) {
        long startTime = System.currentTimeMillis();
        try {
            File transformedFile = this.getPluginTransformer().transform(pluginArtifact, this.osgi.getHostComponentRegistrations());
            JarPluginArtifact jarPluginArtifact = new JarPluginArtifact(transformedFile, true, ReferenceMode.PERMIT_REFERENCE);
            return jarPluginArtifact;
        }
        finally {
            log.info("Plugin [{}] transformed in {}ms", (Object)pluginArtifact.getName(), (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private Plugin reportUnloadablePlugin(File file, Exception e) {
        String msg = "Unable to load plugin: " + String.valueOf(file);
        log.error(msg, (Throwable)e);
        UnloadablePlugin plugin = new UnloadablePlugin();
        plugin.setErrorText("Unable to load plugin: " + e.getMessage());
        return plugin;
    }

    public static class DefaultPluginTransformerFactory
    implements PluginTransformerFactory {
        @Override
        public PluginTransformer newPluginTransformer(OsgiPersistentCache cache, SystemExports systemExports, Set<Application> applicationKeys, String pluginDescriptorPath, OsgiContainerManager osgi) {
            return new DefaultPluginTransformer(cache, systemExports, applicationKeys, pluginDescriptorPath, osgi);
        }
    }

    public static interface PluginTransformerFactory {
        public PluginTransformer newPluginTransformer(OsgiPersistentCache var1, SystemExports var2, Set<Application> var3, String var4, OsgiContainerManager var5);
    }
}

