/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook.dmz;

import java.util.Set;
import org.osgi.framework.Bundle;

public class PluginTypeDetector {
    private final Set<String> bundledPluginKeys;

    public PluginTypeDetector(Set<String> bundledPluginKeys) {
        this.bundledPluginKeys = bundledPluginKeys;
    }

    public boolean isInternalPlugin(Bundle bundle) {
        String pluginKey = this.getPluginKeyOrSymbolicName(bundle);
        return pluginKey.startsWith("com.atlassian") || pluginKey.startsWith("com.riadalabs") || this.bundledPluginKeys.contains(pluginKey);
    }

    public boolean isSystemBundle(Bundle bundle) {
        return bundle.getBundleId() == 0L;
    }

    public String getPluginKeyOrSymbolicName(Bundle bundle) {
        String atlassianPluginKey = (String)bundle.getHeaders().get("Atlassian-Plugin-Key");
        if (atlassianPluginKey == null) {
            return bundle.getSymbolicName();
        }
        return atlassianPluginKey;
    }
}

