package com.atlassian.plugin.servlet;

import java.util.Collections;
import java.util.Enumeration;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;

import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;

/**
 * Instances of the PluginServletConfig are passed to plugins servlet {@link Servlet} init() method. It provides
 * access to the init parameters defined in the plugin xml as well as the ServletContext shared by other filters and
 * servlets in the plugin.
 */
public final class PluginServletConfig implements ServletConfig {
    private final BaseServletModuleDescriptor<?> descriptor;
    private final ServletContext servletContext;

    public PluginServletConfig(BaseServletModuleDescriptor<?> descriptor, ServletContext servletContext) {
        this.descriptor = descriptor;
        this.servletContext = servletContext;
    }

    public String getServletName() {
        return descriptor.getDisplayName();
    }

    public ServletContext getServletContext() {
        return servletContext;
    }

    public String getInitParameter(String s) {
        return descriptor.getInitParams().get(s);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(descriptor.getInitParams().keySet());
    }
}
