package com.atlassian.pocketknife.internal.querydsl.schema;

import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;

import java.util.Optional;

/**
 * A simple component to wrap how we get the product schema.  This helps simplify our dependencies
 */
public class ProductSchemaProvider {

    private final TransactionalExecutorFactory executorFactory;

    public ProductSchemaProvider(TransactionalExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public Optional<String> getProductSchema() {
        return Optional.ofNullable(executorFactory.createReadOnly().getSchemaName().getOrNull());
    }


}
