/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.api.route;

import com.atlassian.prettyurls.api.route.DestinationUrlGenerator;
import com.atlassian.prettyurls.api.route.RoutePredicate;
import com.atlassian.prettyurls.api.route.RoutePredicates;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class UrlRouteRule {
    private final String from;
    private final String to;
    private final DestinationUrlGenerator toUriGenerator;
    private final ParameterMode parameterMode;
    private final List<String> httpVerbs;
    private final RoutePredicate<UrlRouteRule> predicate;

    public UrlRouteRule(String from, String to, List<String> httpVerbs, ParameterMode parameterMode) {
        this(from, to, httpVerbs, parameterMode, RoutePredicates.alwaysTrue());
    }

    public UrlRouteRule(String from, String to, List<String> httpVerbs, ParameterMode parameterMode, RoutePredicate<UrlRouteRule> predicate) {
        this(from, to, null, httpVerbs, parameterMode, predicate);
    }

    public UrlRouteRule(String from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, ParameterMode parameterMode) {
        this(from, toUriGenerator, httpVerbs, parameterMode, RoutePredicates.alwaysTrue());
    }

    public UrlRouteRule(String from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, ParameterMode parameterMode, RoutePredicate<UrlRouteRule> predicate) {
        this(from, null, toUriGenerator, httpVerbs, parameterMode, predicate);
    }

    private UrlRouteRule(String from, String to, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, ParameterMode parameterMode, RoutePredicate<UrlRouteRule> predicate) {
        this.from = Objects.requireNonNull(from);
        this.to = to;
        this.toUriGenerator = toUriGenerator;
        this.httpVerbs = Objects.requireNonNull(httpVerbs);
        this.parameterMode = Objects.requireNonNull(parameterMode);
        this.predicate = Objects.requireNonNull(predicate);
    }

    public String getFrom() {
        return this.from;
    }

    @Nullable
    public String getTo() {
        return this.to;
    }

    @Nullable
    public DestinationUrlGenerator getToUriGenerator() {
        return this.toUriGenerator;
    }

    public ParameterMode getParameterMode() {
        return this.parameterMode;
    }

    public List<String> getHttpVerbs() {
        return this.httpVerbs;
    }

    public RoutePredicate<UrlRouteRule> getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return "UrlRouteRule{from=" + this.from + ", to=" + this.to + ", httpVerbs=" + String.valueOf(this.httpVerbs) + ", parameterMode=" + String.valueOf((Object)this.parameterMode) + ", predicate=" + String.valueOf(this.predicate) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlRouteRule that = (UrlRouteRule)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && this.parameterMode == that.parameterMode && Objects.equals(this.httpVerbs, that.httpVerbs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.to, this.parameterMode, this.httpVerbs});
    }

    public static enum ParameterMode {
        PASS_ALL,
        PASS_UNMAPPED,
        PASS_NONE;

    }
}

