/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.api.route;

import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.prettyurls.api.route.DestinationUrlGenerator;
import com.atlassian.prettyurls.api.route.RoutePredicate;
import com.atlassian.prettyurls.api.route.RoutePredicates;
import com.atlassian.prettyurls.api.route.UrlRouteRule;
import com.atlassian.prettyurls.api.route.UrlRouteRuleSetKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class UrlRouteRuleSet {
    private final List<UrlRouteRule> urlRouteRules;
    private final List<String> topLevelPaths;
    private final UrlRouteRuleSetKey key;
    private final FilterLocation filterLocation;
    private final RoutePredicate<UrlRouteRuleSet> predicate;

    UrlRouteRuleSet(UrlRouteRuleSetKey key, List<String> topLevelPaths, List<UrlRouteRule> urlRouteRules, FilterLocation filterLocation, RoutePredicate<UrlRouteRuleSet> predicate) {
        this.key = Objects.requireNonNull(key);
        this.urlRouteRules = Objects.requireNonNull(urlRouteRules);
        this.topLevelPaths = Objects.requireNonNull(topLevelPaths);
        this.filterLocation = Objects.requireNonNull(filterLocation);
        this.predicate = Objects.requireNonNull(predicate);
    }

    public List<String> getTopLevelPaths() {
        return new ArrayList<String>(this.topLevelPaths);
    }

    public List<UrlRouteRule> getUrlRouteRules() {
        return new ArrayList<UrlRouteRule>(this.urlRouteRules);
    }

    public UrlRouteRuleSetKey getKey() {
        return this.key;
    }

    public FilterLocation getFilterLocation() {
        return this.filterLocation;
    }

    public RoutePredicate<UrlRouteRuleSet> getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return "UrlRouteRuleSet{key=" + String.valueOf(this.key) + ", filterLocation=" + String.valueOf(this.filterLocation) + ", topLevelPaths=" + String.valueOf(this.topLevelPaths) + ", urlRouteRules=" + String.valueOf(this.urlRouteRules) + ", predicate=" + String.valueOf(this.predicate) + "}";
    }

    public static class Builder {
        private List<UrlRouteRule> urlRouteRules = new ArrayList<UrlRouteRule>();
        private List<String> topLevelPaths = new ArrayList<String>();
        private UrlRouteRuleSetKey key;
        private FilterLocation filterLocation = FilterLocation.BEFORE_DISPATCH;
        private RoutePredicate<UrlRouteRuleSet> predicate = RoutePredicates.alwaysTrue();

        public Builder setKey(UrlRouteRuleSetKey key) {
            this.key = Objects.requireNonNull(key);
            return this;
        }

        public Builder setLocation(FilterLocation location) {
            this.filterLocation = Objects.requireNonNull(location);
            return this;
        }

        public Builder setPredicate(RoutePredicate<UrlRouteRuleSet> predicate) {
            this.predicate = Objects.requireNonNull(predicate);
            return this;
        }

        public Builder addTopLevelPath(String path) {
            Objects.requireNonNull(path);
            this.topLevelPaths.add((String)(path.startsWith("/") ? path : "/" + path));
            return this;
        }

        public Builder addRule(String from, String to, List<String> httpVerbs, RoutePredicate<UrlRouteRule> routePredicate, UrlRouteRule.ParameterMode parameterMode) {
            this.urlRouteRules.add(new UrlRouteRule(from, to, httpVerbs, parameterMode, routePredicate));
            return this;
        }

        public Builder addRule(String from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs) {
            this.urlRouteRules.add(new UrlRouteRule(from, toUriGenerator, httpVerbs, UrlRouteRule.ParameterMode.PASS_UNMAPPED));
            return this;
        }

        public Builder addRule(String from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, RoutePredicate<UrlRouteRule> routePredicate, UrlRouteRule.ParameterMode parameterMode) {
            this.urlRouteRules.add(new UrlRouteRule(from, toUriGenerator, httpVerbs, parameterMode, routePredicate));
            return this;
        }

        public Builder addRule(String from, String to) {
            this.urlRouteRules.add(new UrlRouteRule(from, to, Collections.emptyList(), UrlRouteRule.ParameterMode.PASS_UNMAPPED));
            return this;
        }

        public Builder addRule(String from, String to, List<String> httpVerbs) {
            this.urlRouteRules.add(new UrlRouteRule(from, to, httpVerbs, UrlRouteRule.ParameterMode.PASS_UNMAPPED));
            return this;
        }

        public Builder addRule(String from, String to, List<String> httpVerbs, RoutePredicate routePredicate) {
            this.urlRouteRules.add(new UrlRouteRule(from, to, httpVerbs, UrlRouteRule.ParameterMode.PASS_UNMAPPED, (RoutePredicate<UrlRouteRule>)routePredicate));
            return this;
        }

        public UrlRouteRuleSet build() {
            Objects.requireNonNull(this.key, "You must provide a key to identify your rule set");
            if (this.topLevelPaths.isEmpty()) {
                throw new IllegalStateException("You must provide at least one top level path");
            }
            return new UrlRouteRuleSet(this.key, this.topLevelPaths, this.urlRouteRules, this.filterLocation, this.predicate);
        }
    }
}

