/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.db.internal.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.atlassian.ratelimiting.dao.UserRateLimitCounter;
import com.atlassian.ratelimiting.dao.UserRateLimitCounterDao;
import com.atlassian.ratelimiting.db.internal.dao.Tables;
import com.atlassian.ratelimiting.db.internal.dao.utils.DaoUtils;
import com.atlassian.ratelimiting.history.RateLimitingReportSearchRequest;
import com.atlassian.ratelimiting.history.UserRateLimitingReport;
import com.atlassian.ratelimiting.page.Page;
import com.atlassian.ratelimiting.page.PageRequest;
import com.atlassian.ratelimiting.page.Pages;
import com.atlassian.sal.api.user.UserKey;
import com.querydsl.core.QueryResults;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QDSLUserRateLimitCounterDao
implements UserRateLimitCounterDao {
    private static final Logger logger = LoggerFactory.getLogger(QDSLUserRateLimitCounterDao.class);
    private static final Clock CLOCK = Clock.systemUTC();
    private static final String DEFAULT_NODE_ID = DaoUtils.getNodeId();
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public QDSLUserRateLimitCounterDao(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    public UserRateLimitCounter create(UserRateLimitCounter counter) {
        String nodeId = Objects.nonNull(counter.getNodeId()) ? counter.getNodeId() : DEFAULT_NODE_ID;
        Instant utcInstant = counter.getIntervalStart().atZone(CLOCK.getZone()).toInstant();
        Long newId = (Long)this.databaseAccessor.runInTransaction(databaseConnection -> (Long)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)databaseConnection.insert((RelationalPath)Tables.RL_COUNTER).set((Path)Tables.RL_COUNTER.NODE_ID, (Object)nodeId)).set((Path)Tables.RL_COUNTER.USER_ID, (Object)counter.getUser().getStringValue())).set(Tables.RL_COUNTER.INTERVAL_START, (Object)Date.from(utcInstant))).set(Tables.RL_COUNTER.REJECT_COUNT, (Object)counter.getRejectCount())).executeWithKey(Tables.RL_COUNTER.ID), () -> logger.error("Caught error inserting counter: [{}] into DB - rolling back transaction!", (Object)counter));
        UserRateLimitCounter userRateLimitCounter = counter.copy().id(newId.longValue()).nodeId(nodeId).intervalStart(LocalDateTime.ofInstant(utcInstant, CLOCK.getZone())).build();
        logger.trace("Created rate limiting Counter: [{}]", (Object)userRateLimitCounter);
        return userRateLimitCounter;
    }

    public long deleteOlderThan(Duration duration) {
        Date timeFromWhichToDelete = DaoUtils.pastTimeDownToDurationFromNow(duration, CLOCK);
        return (Long)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLDeleteClause)databaseConnection.delete((RelationalPath)Tables.RL_COUNTER).where((Predicate)Tables.RL_COUNTER.INTERVAL_START.lt((Comparable)timeFromWhichToDelete))).execute(), () -> logger.error("Caught error deleting counters older than: [{}] from DB - rolling back transaction!", (Object)timeFromWhichToDelete));
    }

    public long count() {
        return (Long)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)databaseConnection.select(Tables.RL_COUNTER.ID).from((Expression)Tables.RL_COUNTER)).fetchCount(), OnRollback.NOOP);
    }

    public Page<UserRateLimitingReport> getAggregateCounts(RateLimitingReportSearchRequest searchRequest) {
        QueryResults results = (QueryResults)this.databaseAccessor.runInTransaction(databaseConnection -> {
            BooleanExpression hasExemption = (BooleanExpression)new CaseBuilder().when((Predicate)Tables.RL_USER_SETTINGS.USER_ID.isNotNull()).then(true).otherwise((Object)false);
            SQLQuery sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)databaseConnection.select(new Expression[]{Tables.RL_COUNTER.USER_ID, Tables.RL_COUNTER.REJECT_COUNT.sum(), Tables.RL_COUNTER.INTERVAL_START.max(), hasExemption}).from((Expression)Tables.RL_COUNTER)).leftJoin((EntityPath)Tables.RL_USER_SETTINGS)).on((Predicate)Tables.RL_COUNTER.USER_ID.eq((Expression)Tables.RL_USER_SETTINGS.USER_ID));
            if (searchRequest.isUserFilterSearchQuery()) {
                sqlQuery.where((Predicate)Tables.RL_COUNTER.USER_ID.in((Collection)searchRequest.getUserFilterList()));
            }
            if (searchRequest.isDateRangeSearchQuery()) {
                sqlQuery.where((Predicate)Tables.RL_COUNTER.INTERVAL_START.between((Comparable)DaoUtils.getUtcStartTime(searchRequest), (Comparable)DaoUtils.getUtcFinishTime(searchRequest, CLOCK)));
            }
            return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)sqlQuery.groupBy(new Expression[]{Tables.RL_COUNTER.USER_ID, Tables.RL_USER_SETTINGS.USER_ID})).orderBy(this.applySortOrder(searchRequest))).offset((long)searchRequest.getPageRequest().getOffset())).limit((long)searchRequest.getPageRequest().getSize())).fetchResults();
        }, OnRollback.NOOP);
        List list = results.getResults().stream().map(this::mapAggregatedResults).collect(Collectors.toList());
        return Pages.createPage(list, (PageRequest)searchRequest.getPageRequest(), (int)((int)results.getTotal()));
    }

    private OrderSpecifier<?> applySortOrder(RateLimitingReportSearchRequest searchRequest) {
        return searchRequest.isFrequencySortOrder() ? Tables.RL_COUNTER.REJECT_COUNT.sum().desc() : Tables.RL_COUNTER.INTERVAL_START.max().desc();
    }

    private UserRateLimitingReport mapAggregatedResults(Tuple tuple) {
        return new UserRateLimitingReport(new UserKey((String)tuple.get(0, String.class)), LocalDateTime.ofInstant(((Date)tuple.get(2, Date.class)).toInstant(), CLOCK.getZone()), ((Long)tuple.get(1, Long.class)).longValue(), ((Boolean)tuple.get(3, Boolean.class)).booleanValue());
    }
}

