/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.db.internal.dao;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.util.OnRollback;
import com.atlassian.ratelimiting.dao.DefaultUserRateLimitSettings;
import com.atlassian.ratelimiting.dao.RateLimitingSettingsVersionDao;
import com.atlassian.ratelimiting.dao.UserRateLimitSettingsDao;
import com.atlassian.ratelimiting.db.internal.dao.Tables;
import com.atlassian.ratelimiting.dmz.TokenBucketSettings;
import com.atlassian.ratelimiting.dmz.UserRateLimitSettings;
import com.atlassian.ratelimiting.dmz.UserRateLimitSettingsSearchRequest;
import com.atlassian.ratelimiting.page.Page;
import com.atlassian.ratelimiting.page.PageRequest;
import com.atlassian.ratelimiting.page.Pages;
import com.atlassian.sal.api.user.UserKey;
import com.querydsl.core.QueryResults;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class QDSLUserRateLimitSettingsDao
implements UserRateLimitSettingsDao {
    private static final Logger logger = LoggerFactory.getLogger(QDSLUserRateLimitSettingsDao.class);
    private static final int NULL_PLACEHOLDER_VALUE = -1;
    private static final TokenBucketSettings DEFAULT_BUCKET_VALUES = new TokenBucketSettings(-1, -1, 1, ChronoUnit.SECONDS);
    private final DatabaseAccessor databaseAccessor;
    private final RateLimitingSettingsVersionDao settingsVersionDao;

    @Autowired
    public QDSLUserRateLimitSettingsDao(DatabaseAccessor databaseAccessor, RateLimitingSettingsVersionDao settingsVersionDao) {
        this.databaseAccessor = databaseAccessor;
        this.settingsVersionDao = settingsVersionDao;
    }

    public Optional<UserRateLimitSettings> get(UserKey userKey) {
        logger.debug("Looking for user settings for userId: [{}]", (Object)userKey.getStringValue());
        Tuple tuple = (Tuple)this.databaseAccessor.runInTransaction(databaseConnection -> (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.RL_USER_SETTINGS.all()).from((Expression)Tables.RL_USER_SETTINGS)).where((Predicate)Tables.RL_USER_SETTINGS.USER_ID.eq((Object)userKey.getStringValue()))).fetchFirst(), OnRollback.NOOP);
        return Objects.isNull(tuple) ? Optional.empty() : Optional.of(this.getUserRateLimitSettings(tuple));
    }

    private UserRateLimitSettings getUserRateLimitSettings(Tuple tuple) {
        TokenBucketSettings bucketSettings = new TokenBucketSettings(((Integer)tuple.get(Tables.RL_USER_SETTINGS.CAPACITY)).intValue(), ((Integer)tuple.get(Tables.RL_USER_SETTINGS.FILL_RATE)).intValue(), ((Integer)tuple.get(Tables.RL_USER_SETTINGS.INTERVAL_FREQUENCY)).intValue(), ChronoUnit.valueOf((String)tuple.get((Expression)Tables.RL_USER_SETTINGS.INTERVAL_TIME_UNIT)));
        DefaultUserRateLimitSettings.Builder builder = DefaultUserRateLimitSettings.builder((UserKey)new UserKey((String)tuple.get((Expression)Tables.RL_USER_SETTINGS.USER_ID))).withSettings(bucketSettings);
        return Boolean.TRUE.equals(tuple.get((Expression)Tables.RL_USER_SETTINGS.WHITELISTED)) ? builder.whitelisted().build() : builder.build();
    }

    public List<UserRateLimitSettings> findAll() {
        QueryResults<Tuple> results = this.findUsers(null, null);
        return results.getResults().stream().map(this::getUserRateLimitSettings).collect(Collectors.toList());
    }

    public Page<UserRateLimitSettings> search(UserRateLimitSettingsSearchRequest searchRequest, PageRequest pageRequest) {
        Objects.requireNonNull(searchRequest, "request");
        Objects.requireNonNull(pageRequest, "pageRequest");
        if (!Objects.isNull(searchRequest.getFilter()) && !searchRequest.getFilter().isEmpty()) {
            return this.findAll(pageRequest, searchRequest.getFilter());
        }
        return this.findAll(pageRequest);
    }

    public UserRateLimitSettings saveOrUpdate(UserRateLimitSettings userRateLimitSettings) {
        Optional<UserRateLimitSettings> found = this.get(userRateLimitSettings.getUserKey());
        return !found.isPresent() ? this.create(userRateLimitSettings) : this.update(userRateLimitSettings);
    }

    UserRateLimitSettings create(UserRateLimitSettings userRateLimitSettings) {
        logger.debug("Creating User Rate Limiting Settings: [{}]", (Object)userRateLimitSettings);
        String createdKey = (String)this.databaseAccessor.runInTransaction(databaseConnection -> {
            String newKey = (String)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)databaseConnection.insert((RelationalPath)Tables.RL_USER_SETTINGS).set(Tables.RL_USER_SETTINGS.CAPACITY, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getCapacity())).set(Tables.RL_USER_SETTINGS.FILL_RATE, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getFillRate())).set(Tables.RL_USER_SETTINGS.INTERVAL_FREQUENCY, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getIntervalFrequency())).set((Path)Tables.RL_USER_SETTINGS.INTERVAL_TIME_UNIT, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getIntervalTimeUnit().name())).set((Path)Tables.RL_USER_SETTINGS.USER_ID, (Object)userRateLimitSettings.getUserKey().getStringValue())).set((Path)Tables.RL_USER_SETTINGS.WHITELISTED, (Object)userRateLimitSettings.isWhitelisted())).executeWithKey((Path)Tables.RL_USER_SETTINGS.USER_ID);
            this.settingsVersionDao.incrementUserSettingsVersion();
            return newKey;
        }, () -> logger.error("Caught error creating user rate limiting settings: [{}] into DB - rolling back transaction!", (Object)userRateLimitSettings));
        logger.debug("Returning created entity: [{}]", (Object)createdKey);
        return userRateLimitSettings;
    }

    private UserRateLimitSettings update(UserRateLimitSettings userRateLimitSettings) {
        logger.debug("Updating user rate limiting settings: [{}]", (Object)userRateLimitSettings);
        long updatedCount = (Long)this.databaseAccessor.runInTransaction(databaseConnection -> {
            long count = ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)databaseConnection.update((RelationalPath)Tables.RL_USER_SETTINGS).set(Tables.RL_USER_SETTINGS.CAPACITY, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getCapacity())).set(Tables.RL_USER_SETTINGS.FILL_RATE, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getFillRate())).set(Tables.RL_USER_SETTINGS.INTERVAL_FREQUENCY, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getIntervalFrequency())).set((Path)Tables.RL_USER_SETTINGS.INTERVAL_TIME_UNIT, (Object)userRateLimitSettings.getSettings().orElse(DEFAULT_BUCKET_VALUES).getIntervalTimeUnit().name())).set((Path)Tables.RL_USER_SETTINGS.WHITELISTED, (Object)userRateLimitSettings.isWhitelisted())).where((Predicate)Tables.RL_USER_SETTINGS.USER_ID.eq((Object)userRateLimitSettings.getUserKey().getStringValue()))).execute();
            this.settingsVersionDao.incrementUserSettingsVersion();
            return count;
        }, () -> logger.error("Caught error updating user rate limiting settings: [{}] into DB - rolling back transaction!", (Object)userRateLimitSettings));
        logger.debug("Returning updated entities: [{}]", (Object)updatedCount);
        return userRateLimitSettings;
    }

    public void delete(UserKey userKey) {
        logger.debug("Deleting rate limiting exemptions for userKey: [{}]", (Object)userKey);
        long deletedCount = (Long)this.databaseAccessor.runInTransaction(databaseConnection -> {
            long count = ((SQLDeleteClause)databaseConnection.delete((RelationalPath)Tables.RL_USER_SETTINGS).where((Predicate)Tables.RL_USER_SETTINGS.USER_ID.eq((Object)userKey.getStringValue()))).execute();
            this.settingsVersionDao.incrementUserSettingsVersion();
            return count;
        }, () -> logger.error("Caught error deleting rate limiting settings for user: [{}] from DB - rolling back transaction!", (Object)userKey));
        logger.debug("Deleted num entities: [{}]", (Object)deletedCount);
    }

    private Page<UserRateLimitSettings> findAll(PageRequest pageRequest) {
        return this.findAll(pageRequest, Collections.emptyList());
    }

    private Page<UserRateLimitSettings> findAll(PageRequest pageRequest, List<String> userIds) {
        QueryResults<Tuple> results = this.findUsers(pageRequest, userIds);
        List list = results.getResults().stream().map(this::getUserRateLimitSettings).collect(Collectors.toList());
        return Pages.createPage(list, (PageRequest)pageRequest, (int)((int)results.getTotal()));
    }

    private QueryResults<Tuple> findUsers(PageRequest pageRequest, List<String> userIds) {
        return (QueryResults)this.databaseAccessor.runInTransaction(databaseConnection -> {
            SQLQuery sqlQuery = (SQLQuery)databaseConnection.select((Expression[])Tables.RL_USER_SETTINGS.all()).from((Expression)Tables.RL_USER_SETTINGS);
            if (!CollectionUtils.isEmpty((Collection)userIds)) {
                sqlQuery.where((Predicate)Tables.RL_USER_SETTINGS.USER_ID.in((Collection)userIds));
            }
            if (Objects.nonNull(pageRequest)) {
                ((SQLQuery)sqlQuery.offset((long)pageRequest.getOffset())).limit((long)pageRequest.getSize());
            }
            return ((SQLQuery)sqlQuery.orderBy(Tables.RL_USER_SETTINGS.USER_ID.asc())).fetchResults();
        }, OnRollback.NOOP);
    }

    public Optional<Long> getLatestUserSettingsVersion() {
        return this.settingsVersionDao.getLatestUserSettingsVersion();
    }

    public long getExemptionsCount() {
        return (Long)this.databaseAccessor.runInTransaction(databaseConnection -> ((SQLQuery)databaseConnection.select((Expression)Tables.RL_USER_SETTINGS.USER_ID).from((Expression)Tables.RL_USER_SETTINGS)).fetchCount(), OnRollback.NOOP);
    }
}

