/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl.schema;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.pocketknife.internal.querydsl.cache.PKQCacheClearer;
import com.atlassian.pocketknife.internal.querydsl.schema.JdbcTableAndColumns;
import com.atlassian.pocketknife.internal.querydsl.schema.JdbcTableInspector;
import com.atlassian.pocketknife.internal.querydsl.schema.ProductSchemaProvider;
import com.atlassian.pocketknife.internal.querydsl.schema.SchemaProvider;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class DefaultSchemaProvider
implements SchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultSchemaProvider.class);
    private final ConcurrentHashMap<UpperCaseNameKey, String> tableAndColumnNames;
    private final ProductSchemaProvider productSchemaProvider;
    private final PKQCacheClearer cacheClearer;
    private final JdbcTableInspector tableInspector;

    public DefaultSchemaProvider(ProductSchemaProvider productSchemaProvider, JdbcTableInspector tableInspector, PKQCacheClearer cacheClearer) {
        this.productSchemaProvider = productSchemaProvider;
        this.tableInspector = tableInspector;
        this.cacheClearer = cacheClearer;
        this.tableAndColumnNames = new ConcurrentHashMap();
    }

    @PostConstruct
    void postConstruct() {
        this.cacheClearer.registerCacheClearing(this.tableAndColumnNames::clear);
    }

    @VisibleForTesting
    Map<UpperCaseNameKey, String> getTableAndColumnNames() {
        return this.tableAndColumnNames;
    }

    @Override
    public Optional<String> getProductSchema() {
        return this.productSchemaProvider.getProductSchema();
    }

    @Override
    public Optional<String> getTableName(Connection connection, String logicalTableName) {
        if (DefaultSchemaProvider.isEmpty(logicalTableName)) {
            throw new IllegalArgumentException("Table name is required");
        }
        UpperCaseNameKey key = new UpperCaseNameKey(logicalTableName);
        String tableName = this.tableAndColumnNames.get(key);
        if (tableName == null) {
            this.cacheTableAndColumns(connection, logicalTableName);
            tableName = this.tableAndColumnNames.get(key);
        }
        return this.logMissing(tableName, logicalTableName, "table:" + logicalTableName);
    }

    @Override
    public Optional<String> getColumnName(Connection connection, String logicalTableName, String logicalColumnName) {
        if (DefaultSchemaProvider.isEmpty(logicalTableName)) {
            throw new IllegalArgumentException("Table name is required");
        }
        if (DefaultSchemaProvider.isEmpty(logicalColumnName)) {
            throw new IllegalArgumentException("Column name is required");
        }
        UpperCaseNameKey key = new UpperCaseNameKey(logicalTableName, logicalColumnName);
        String columnName = this.tableAndColumnNames.get(key);
        if (columnName == null) {
            this.cacheTableAndColumns(connection, logicalTableName);
            columnName = this.tableAndColumnNames.get(key);
        }
        return this.logMissing(columnName, logicalColumnName, "column:" + logicalTableName + "." + logicalColumnName);
    }

    private Optional<String> logMissing(@Nullable String physical, String logical, String targetName) {
        Optional<String> dbObj = Optional.ofNullable(physical);
        if (dbObj.isEmpty()) {
            log.warn("Could not find the physical database object for the logically named '{}' aka '{}'. Is this expected database state?", (Object)logical, (Object)targetName);
        }
        return dbObj;
    }

    private void cacheTableAndColumns(Connection connection, String logicalTableName) {
        JdbcTableAndColumns tableAndColumns = this.tableInspector.inspectTableAndColumns(connection, this.getProductSchema(), logicalTableName);
        if (tableAndColumns.getTableName().isDefined()) {
            String realTableName = (String)tableAndColumns.getTableName().get();
            UpperCaseNameKey tableKey = new UpperCaseNameKey(realTableName);
            this.tableAndColumnNames.put(tableKey, realTableName);
            for (String realColumnName : tableAndColumns.getColumnNames()) {
                UpperCaseNameKey columnKey = new UpperCaseNameKey(realTableName, realColumnName);
                this.tableAndColumnNames.put(columnKey, realColumnName);
            }
        }
    }

    private static boolean isEmpty(@Nullable String input) {
        return input == null || input.isEmpty();
    }

    private static class UpperCaseNameKey {
        private final String tableName;
        private final String columnName;

        private UpperCaseNameKey(@Nonnull String tableName) {
            this(tableName, null);
        }

        private UpperCaseNameKey(@Nonnull String tableName, @Nullable String columnName) {
            this.tableName = Objects.requireNonNull(tableName).toUpperCase();
            this.columnName = columnName == null ? null : columnName.toUpperCase();
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            UpperCaseNameKey other = (UpperCaseNameKey)obj;
            return this.tableName.equals(other.tableName) && (this.columnName == null ? other.columnName == null : this.columnName.equals(other.columnName));
        }

        public int hashCode() {
            int result = this.tableName.hashCode();
            result = 31 * result + (this.columnName != null ? this.columnName.hashCode() : 0);
            return result;
        }
    }
}

