/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.history;

import com.atlassian.ratelimiting.history.RateLimitingReportOrder;
import com.atlassian.ratelimiting.page.PageRequest;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class RateLimitingReportSearchRequest {
    private final List<String> userFilterList;
    private final RateLimitingReportOrder sortOrder;
    private final ZonedDateTime startTime;
    private final ZonedDateTime finishTime;
    private final PageRequest pageRequest;

    public boolean isDateRangeSearchQuery() {
        return Objects.nonNull(this.startTime) || Objects.nonNull(this.finishTime);
    }

    public boolean isUserFilterSearchQuery() {
        return Objects.nonNull(this.userFilterList) && !this.userFilterList.isEmpty();
    }

    public boolean isFrequencySortOrder() {
        return RateLimitingReportOrder.FREQUENCY.equals((Object)this.sortOrder);
    }

    @Generated
    private static RateLimitingReportOrder $default$sortOrder() {
        return RateLimitingReportOrder.FREQUENCY;
    }

    @Generated
    private static PageRequest $default$pageRequest() {
        return new PageRequest(0, 20);
    }

    @Generated
    RateLimitingReportSearchRequest(List<String> userFilterList, RateLimitingReportOrder sortOrder, ZonedDateTime startTime, ZonedDateTime finishTime, PageRequest pageRequest) {
        this.userFilterList = userFilterList;
        this.sortOrder = sortOrder;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.pageRequest = pageRequest;
    }

    @Generated
    public static RateLimitingReportSearchRequestBuilder builder() {
        return new RateLimitingReportSearchRequestBuilder();
    }

    @Generated
    public String toString() {
        return "RateLimitingReportSearchRequest(userFilterList=" + String.valueOf(this.getUserFilterList()) + ", sortOrder=" + String.valueOf((Object)this.getSortOrder()) + ", startTime=" + String.valueOf(this.getStartTime()) + ", finishTime=" + String.valueOf(this.getFinishTime()) + ", pageRequest=" + String.valueOf(this.getPageRequest()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitingReportSearchRequest)) {
            return false;
        }
        RateLimitingReportSearchRequest other = (RateLimitingReportSearchRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$userFilterList = this.getUserFilterList();
        List<String> other$userFilterList = other.getUserFilterList();
        if (this$userFilterList == null ? other$userFilterList != null : !((Object)this$userFilterList).equals(other$userFilterList)) {
            return false;
        }
        RateLimitingReportOrder this$sortOrder = this.getSortOrder();
        RateLimitingReportOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        ZonedDateTime this$startTime = this.getStartTime();
        ZonedDateTime other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        ZonedDateTime this$finishTime = this.getFinishTime();
        ZonedDateTime other$finishTime = other.getFinishTime();
        if (this$finishTime == null ? other$finishTime != null : !((Object)this$finishTime).equals(other$finishTime)) {
            return false;
        }
        PageRequest this$pageRequest = this.getPageRequest();
        PageRequest other$pageRequest = other.getPageRequest();
        return !(this$pageRequest == null ? other$pageRequest != null : !((Object)this$pageRequest).equals(other$pageRequest));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RateLimitingReportSearchRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $userFilterList = this.getUserFilterList();
        result = result * 59 + ($userFilterList == null ? 43 : ((Object)$userFilterList).hashCode());
        RateLimitingReportOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        ZonedDateTime $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        ZonedDateTime $finishTime = this.getFinishTime();
        result = result * 59 + ($finishTime == null ? 43 : ((Object)$finishTime).hashCode());
        PageRequest $pageRequest = this.getPageRequest();
        result = result * 59 + ($pageRequest == null ? 43 : ((Object)$pageRequest).hashCode());
        return result;
    }

    @Generated
    public List<String> getUserFilterList() {
        return this.userFilterList;
    }

    @Generated
    public RateLimitingReportOrder getSortOrder() {
        return this.sortOrder;
    }

    @Generated
    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    @Generated
    public ZonedDateTime getFinishTime() {
        return this.finishTime;
    }

    @Generated
    public PageRequest getPageRequest() {
        return this.pageRequest;
    }

    @Generated
    public static class RateLimitingReportSearchRequestBuilder {
        @Generated
        private List<String> userFilterList;
        @Generated
        private boolean sortOrder$set;
        @Generated
        private RateLimitingReportOrder sortOrder$value;
        @Generated
        private ZonedDateTime startTime;
        @Generated
        private ZonedDateTime finishTime;
        @Generated
        private boolean pageRequest$set;
        @Generated
        private PageRequest pageRequest$value;

        @Generated
        RateLimitingReportSearchRequestBuilder() {
        }

        @Generated
        public RateLimitingReportSearchRequestBuilder userFilterList(List<String> userFilterList) {
            this.userFilterList = userFilterList;
            return this;
        }

        @Generated
        public RateLimitingReportSearchRequestBuilder sortOrder(RateLimitingReportOrder sortOrder) {
            this.sortOrder$value = sortOrder;
            this.sortOrder$set = true;
            return this;
        }

        @Generated
        public RateLimitingReportSearchRequestBuilder startTime(ZonedDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        @Generated
        public RateLimitingReportSearchRequestBuilder finishTime(ZonedDateTime finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        @Generated
        public RateLimitingReportSearchRequestBuilder pageRequest(PageRequest pageRequest) {
            this.pageRequest$value = pageRequest;
            this.pageRequest$set = true;
            return this;
        }

        @Generated
        public RateLimitingReportSearchRequest build() {
            RateLimitingReportOrder sortOrder$value = this.sortOrder$value;
            if (!this.sortOrder$set) {
                sortOrder$value = RateLimitingReportSearchRequest.$default$sortOrder();
            }
            PageRequest pageRequest$value = this.pageRequest$value;
            if (!this.pageRequest$set) {
                pageRequest$value = RateLimitingReportSearchRequest.$default$pageRequest();
            }
            return new RateLimitingReportSearchRequest(this.userFilterList, sortOrder$value, this.startTime, this.finishTime, pageRequest$value);
        }

        @Generated
        public String toString() {
            return "RateLimitingReportSearchRequest.RateLimitingReportSearchRequestBuilder(userFilterList=" + String.valueOf(this.userFilterList) + ", sortOrder$value=" + String.valueOf((Object)this.sortOrder$value) + ", startTime=" + String.valueOf(this.startTime) + ", finishTime=" + String.valueOf(this.finishTime) + ", pageRequest$value=" + String.valueOf(this.pageRequest$value) + ")";
        }
    }
}

