/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.internal.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.plugin.spring.scanner.annotation.component.CrowdComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.CrowdImport;
import com.atlassian.ratelimiting.featureflag.RateLimitingFeatureFlagService;
import com.atlassian.ratelimiting.internal.featureflag.SalRateLimitingFeatureFlagService;
import com.atlassian.ratelimiting.internal.properties.SystemProperties;
import com.atlassian.ratelimiting.internal.properties.SystemPropertyConfigurableRateLimitingProperties;
import com.atlassian.ratelimiting.internal.requesthandler.DefaultRateLimitUiRequestHandler;
import com.atlassian.ratelimiting.properties.RateLimitingProperties;
import com.atlassian.ratelimiting.properties.WhitelistedEndpoints;
import com.atlassian.ratelimiting.properties.WhitelistedOAuthConsumers;
import com.atlassian.ratelimiting.requesthandler.RateLimitUiRequestHandler;
import com.atlassian.ratelimiting.user.keyprovider.UserKeyProvider;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.springframework.context.annotation.Bean;

@CrowdComponent
public class CrowdRateLimitingConfiguration {
    private final DarkFeatureManager darkFeatureManager;
    private final CrowdService crowdService;
    private final UserManager userManager;
    private final ApplicationManager applicationManager;

    public CrowdRateLimitingConfiguration(@CrowdImport DarkFeatureManager darkFeatureManager, @CrowdImport CrowdService crowdService, @CrowdImport UserManager userManager, @CrowdImport ApplicationManager applicationManager) {
        this.darkFeatureManager = darkFeatureManager;
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.applicationManager = applicationManager;
    }

    @Bean
    public WhitelistedEndpoints whitelistedEndpoints() {
        return Collections::emptySet;
    }

    @Bean
    public RateLimitUiRequestHandler refappRateLimitUiRequestHandler() {
        Set<String> headerNames = Set.of("Referer", "origin");
        Set<String> cookieNames = Set.of("atlassian.xsrf.token", "JSESSIONID");
        int quorumCount = 2;
        return new DefaultRateLimitUiRequestHandler(headerNames, cookieNames, 2);
    }

    @Bean
    public RateLimitingFeatureFlagService rateLimitingFeatureFlagService(DarkFeatureManager darkFeatureManager) {
        return new SalRateLimitingFeatureFlagService(darkFeatureManager);
    }

    @Bean
    public UserKeyProvider userKeyProvider(UserManager userManager) {
        return userName -> Optional.ofNullable(userManager.getUserProfile(userName)).map(UserProfile::getUserKey);
    }

    @Bean
    public RateLimitingProperties confluenceRateLimitingProperties(WhitelistedEndpoints defaultWhitelistedEndpoints, WhitelistedOAuthConsumers defaultWhitelistedOAuthConsumers, SystemProperties systemProperties) {
        return new SystemPropertyConfigurableRateLimitingProperties(defaultWhitelistedEndpoints, defaultWhitelistedOAuthConsumers, systemProperties, false);
    }
}

