/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.internal.filter;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.ratelimiting.dmz.RateLimitingMode;
import com.atlassian.ratelimiting.internal.concurrent.OperationThrottler;
import com.atlassian.ratelimiting.internal.requesthandler.logging.RateLimitedRequestLogger;
import com.atlassian.ratelimiting.internal.settings.RateLimitLightweightAccessService;
import com.atlassian.ratelimiting.node.RateLimitService;
import com.atlassian.ratelimiting.requesthandler.RateLimitOAuth2ClientCredentialsRequestHandler;
import com.atlassian.ratelimiting.requesthandler.RateLimitResponseHandler;
import com.atlassian.ratelimiting.requesthandler.RateLimitUiRequestHandler;
import com.atlassian.ratelimiting.requesthandler.RateLimitUserRequestHandler;
import com.atlassian.ratelimiting.user.UserService;
import com.atlassian.sal.api.user.UserKey;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class RateLimitFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RateLimitFilter.class);
    private static final UserKey INVALID_CLIENT_ID_USER_KEY = new UserKey("oauth2_2lo_request_user_key_unknown-client");
    private final RateLimitUserRequestHandler userRequestRateLimitHandler;
    private final RateLimitOAuth2ClientCredentialsRequestHandler oauth2RequestRateLimitHandler;
    private final RateLimitService rateLimitService;
    private final RateLimitLightweightAccessService rateLimitSettingsService;
    private final UserService userService;
    private final OperationThrottler<UserKey> operationThrottler;
    private final RateLimitResponseHandler rateLimitResponseHandler;
    private final RateLimitedRequestLogger rateLimitedRequestLogger;
    private final RateLimitUiRequestHandler rateLimitUiRequestHandler;

    public RateLimitFilter(RateLimitUserRequestHandler userRequestRateLimitHandler, RateLimitOAuth2ClientCredentialsRequestHandler oauth2RequestRateLimitHandler, RateLimitService rateLimitService, RateLimitLightweightAccessService rateLimitSettingsService, UserService userService, OperationThrottler<UserKey> operationThrottler, RateLimitResponseHandler rateLimitResponseHandler, RateLimitedRequestLogger rateLimitedRequestLogger, RateLimitUiRequestHandler rateLimitUiRequestHandler) {
        this.rateLimitService = rateLimitService;
        this.rateLimitSettingsService = rateLimitSettingsService;
        this.userService = userService;
        this.operationThrottler = operationThrottler;
        this.rateLimitResponseHandler = rateLimitResponseHandler;
        this.rateLimitedRequestLogger = rateLimitedRequestLogger;
        this.rateLimitUiRequestHandler = rateLimitUiRequestHandler;
        this.userRequestRateLimitHandler = userRequestRateLimitHandler;
        this.oauth2RequestRateLimitHandler = oauth2RequestRateLimitHandler;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.requestHasBeenRateLimited(httpRequest, httpResponse)) {
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean requestHasBeenRateLimited(HttpServletRequest request, HttpServletResponse response) throws IOException {
        RateLimitingMode rateLimitingMode = this.rateLimitSettingsService.getRateLimitingMode();
        if (rateLimitingMode.isEnabled()) {
            logger.trace("Checking if rate limiting logic needs to be applied to user request: [{}]", (Object)request.getRequestURI());
            this.rateLimitUiRequestHandler.logRequestInfo(request);
            if (this.oauth2RequestRateLimitHandler.shouldApplyRateLimiting(request)) {
                return this.oauth2RequestHasBeenRateLimited(request, response, rateLimitingMode);
            }
            if (this.userRequestRateLimitHandler.shouldApplyRateLimiting(request)) {
                return this.userHasBeenRateLimited(request, response, rateLimitingMode);
            }
            logger.trace("Request has passed rate limiting - continuing on...");
        } else {
            logger.trace("Rate limiting is off - continuing on...");
        }
        return false;
    }

    private boolean userHasBeenRateLimited(HttpServletRequest request, HttpServletResponse response, RateLimitingMode rateLimitingMode) throws IOException {
        UserKey userKey = Objects.requireNonNull(this.userService.getUserKey(request), "Unexpected null userkey found for request: " + String.valueOf(request));
        boolean userHasBeenRateLimited = !this.rateLimitService.tryAcquire(userKey) && !rateLimitingMode.isDryRun();
        this.handleRequestRateLimitOutcome(userHasBeenRateLimited, userKey, request, response);
        return userHasBeenRateLimited;
    }

    private boolean oauth2RequestHasBeenRateLimited(HttpServletRequest request, HttpServletResponse response, RateLimitingMode rateLimitingMode) throws IOException {
        Object clientIdAttribute = request.getAttribute("oauth2.token.client_id");
        if (!(clientIdAttribute instanceof String)) {
            this.operationThrottler.tryRun(INVALID_CLIENT_ID_USER_KEY, () -> logger.warn("OAuth2 request does not have a valid client_id attribute ({}) - not rate limiting the request", clientIdAttribute));
            return false;
        }
        String clientId = (String)clientIdAttribute;
        UserKey clientIdUserKey = new UserKey("oauth2_2lo_request_user_key_" + clientId);
        boolean requestHasBeenRateLimited = !this.rateLimitService.tryAcquire(clientIdUserKey) && !rateLimitingMode.isDryRun();
        this.handleRequestRateLimitOutcome(requestHasBeenRateLimited, clientIdUserKey, request, response);
        return requestHasBeenRateLimited;
    }

    private void handleRequestRateLimitOutcome(boolean requestHasBeenRateLimited, UserKey userKey, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (requestHasBeenRateLimited) {
            this.operationThrottler.tryRun(userKey, () -> logger.warn("User [{}] has been rate limited", (Object)userKey));
            this.rateLimitResponseHandler.applyRateLimitingInfo(response, request, userKey, () -> this.rateLimitService.getBucket(userKey));
            this.rateLimitedRequestLogger.logRateLimitedRequest(userKey, request);
            return;
        }
        this.rateLimitResponseHandler.addRateLimitingHeaders(response, userKey, () -> this.rateLimitService.getBucket(userKey));
    }

    public void destroy() {
    }
}

