/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.internal.jira.featureflag;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureDisabledEvent;
import com.atlassian.jira.config.FeatureEnabledEvent;
import com.atlassian.ratelimiting.internal.featureflag.DefaultRateLimitingFeatureFlagService;
import com.atlassian.sal.api.features.DarkFeatureManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;

public class JiraRateLimitingFeatureFlagService
extends DefaultRateLimitingFeatureFlagService {
    private final DarkFeatureManager darkFeatureManager;
    private final EventPublisher eventPublisher;

    public JiraRateLimitingFeatureFlagService(DarkFeatureManager darkFeatureManager, EventPublisher eventPublisher) {
        this.darkFeatureManager = darkFeatureManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public boolean getDryRunEnabled() {
        return this.darkFeatureManager.isEnabledForAllUsers("com.atlassian.ratelimiting.dry.run").orElse(false);
    }

    @PostConstruct
    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public boolean isOAuth2RateLimitingEnabled() {
        boolean oauth2RateLimitingTurnedOff = this.darkFeatureManager.isEnabledForAllUsers("com.atlassian.ratelimiting.oauth2.client-credentials.off").orElse(false);
        return !oauth2RateLimitingTurnedOff;
    }

    @EventListener
    public void featureFlagEnabled(FeatureEnabledEvent featureEnabledEvent) {
        if (this.isDryRunKey(featureEnabledEvent.feature())) {
            this.resetDryRunFeatureFlag();
        }
    }

    @EventListener
    public void featureFlagDisabled(FeatureDisabledEvent featureDisabledEvent) {
        if (this.isDryRunKey(featureDisabledEvent.feature())) {
            this.resetDryRunFeatureFlag();
        }
    }
}

