/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.rest.resource;

import com.atlassian.crowd.model.application.ApplicationType;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@Path(value="/users/app-icon")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class IconResource {
    @GET
    @Produces(value={"image/svg+xml"})
    public Response getApplicationProfilePicture(@QueryParam(value="type") String applicationType) throws IOException {
        String appShortName = this.appTypeToIconPrefix(StringUtils.trim((String)applicationType));
        if (appShortName == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        String iconResourceName = String.format("/icons/apps/%s-icon.svg", appShortName);
        return Response.ok((Object)IOUtils.toByteArray((InputStream)this.getClass().getResourceAsStream(iconResourceName))).build();
    }

    @Nullable
    private String appTypeToIconPrefix(String applicationType) {
        if (StringUtils.isBlank((CharSequence)applicationType) || Arrays.stream(ApplicationType.values()).noneMatch(enm -> enm.name().equalsIgnoreCase(applicationType))) {
            return null;
        }
        return applicationType.equalsIgnoreCase(ApplicationType.GENERIC_APPLICATION.name()) ? "other" : applicationType.toLowerCase();
    }
}

