/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ratelimiting.rest.resource;

import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import com.atlassian.ratelimiting.dmz.DmzRateLimitSettingsModificationService;
import com.atlassian.ratelimiting.dmz.UserRateLimitSettingsSearchRequest;
import com.atlassian.ratelimiting.dmz.UserRateLimitSettingsSearchResult;
import com.atlassian.ratelimiting.page.Page;
import com.atlassian.ratelimiting.page.PageRequest;
import com.atlassian.ratelimiting.rest.api.RestBulkUserRateLimitSettingsUpdateRequest;
import com.atlassian.ratelimiting.rest.api.RestExemptionsLimitInfo;
import com.atlassian.ratelimiting.rest.api.RestPage;
import com.atlassian.ratelimiting.rest.api.RestUserRateLimitSettings;
import com.atlassian.ratelimiting.rest.resource.AbstractUserRateLimitSettingsResource;
import com.atlassian.ratelimiting.rest.utils.RestUtils;
import com.atlassian.ratelimiting.user.UserService;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SystemAdminOnly
@Path(value="admin/rate-limit/settings/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class UserRateLimitSettingsResource
extends AbstractUserRateLimitSettingsResource {
    private static final Logger logger = LoggerFactory.getLogger(UserRateLimitSettingsResource.class);

    @Inject
    public UserRateLimitSettingsResource(I18nResolver i18nService, DmzRateLimitSettingsModificationService rateLimitSettingsService, UserService userService, PermissionEnforcer permissionEnforcer) {
        super(i18nService, rateLimitSettingsService, userService, permissionEnforcer);
    }

    @Override
    @GET
    @Path(value="/{userId}")
    public Response getSettings(@PathParam(value="userId") String userId) {
        return super.getSettings(userId);
    }

    @GET
    public Response getAllSettings(@QueryParam(value="filter") List<String> filter, @DefaultValue(value="0") @QueryParam(value="page") int pageNumber, @DefaultValue(value="20") @QueryParam(value="size") int pageSize) {
        this.permissionEnforcer.enforceSystemAdmin();
        List<String> userKeyFilter = RestUtils.lookupUserKeysForUsernames(filter, this.userService);
        logger.debug("Getting All Rate limiting settings with filter: [{}] and paging info: [{},{}]", new Object[]{filter, pageNumber, pageSize});
        Page<UserRateLimitSettingsSearchResult> page = this.rateLimitSettingsService.searchUserSettings(new UserRateLimitSettingsSearchRequest(userKeyFilter), new PageRequest(pageNumber, pageSize));
        return Response.ok(new RestPage<RestUserRateLimitSettings>(page.map(this::mapSearchResult))).build();
    }

    private RestUserRateLimitSettings mapSearchResult(UserRateLimitSettingsSearchResult searchResult) {
        return new RestUserRateLimitSettings(searchResult.getUserRateLimitSettings(), searchResult.getUserProfile());
    }

    @Override
    @PUT
    @Path(value="/token-bucket")
    public Response updateSettingsForMultipleUsers(RestBulkUserRateLimitSettingsUpdateRequest request) {
        return super.updateSettingsForMultipleUsers(request);
    }

    @Override
    @PUT
    @Path(value="/whitelist")
    public Response whitelistMultipleUsers(Set<String> userIds) {
        return super.whitelistMultipleUsers(userIds);
    }

    @Override
    @PUT
    @Path(value="/blacklist")
    public Response blacklistMultipleUsers(Set<String> userIds) {
        return super.blacklistMultipleUsers(userIds);
    }

    @Override
    @DELETE
    @Path(value="/{userId}")
    public Response deleteSettings(@PathParam(value="userId") String userId) {
        return super.deleteSettings(userId);
    }

    @GET
    @Path(value="/exemptionsLimit")
    public Response getExemptionsLimitStatus() {
        this.permissionEnforcer.enforceSystemAdmin();
        RestExemptionsLimitInfo exemptionsInfo = RestExemptionsLimitInfo.builder().maxAllowed(this.rateLimitSettingsService.getExemptionsLimit()).current(this.rateLimitSettingsService.getExemptionsCount()).maxReached(this.rateLimitSettingsService.getExemptionsCount() >= this.rateLimitSettingsService.getExemptionsLimit()).build();
        return Response.ok((Object)exemptionsInfo).build();
    }
}

