/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.mysql;

import com.querydsl.core.JoinFlag;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.QueryMetadata;
import com.querydsl.sql.AbstractSQLQuery;
import com.querydsl.sql.Configuration;
import java.io.File;
import java.sql.Connection;
import java.util.function.Supplier;

public abstract class AbstractMySQLQuery<T, C extends AbstractMySQLQuery<T, C>>
extends AbstractSQLQuery<T, C> {
    protected static final String WITH_ROLLUP = "\nwith rollup ";
    protected static final String STRAIGHT_JOIN = "straight_join ";
    protected static final String SQL_SMALL_RESULT = "sql_small_result ";
    protected static final String SQL_NO_CACHE = "sql_no_cache ";
    protected static final String LOCK_IN_SHARE_MODE = "\nlock in share mode ";
    protected static final String HIGH_PRIORITY = "high_priority ";
    protected static final String SQL_CALC_FOUND_ROWS = "sql_calc_found_rows ";
    protected static final String SQL_CACHE = "sql_cache ";
    protected static final String SQL_BUFFER_RESULT = "sql_buffer_result ";
    protected static final String SQL_BIG_RESULT = "sql_big_result ";

    public AbstractMySQLQuery(Connection conn, Configuration configuration, QueryMetadata metadata) {
        super(conn, configuration, metadata);
    }

    public AbstractMySQLQuery(Supplier<Connection> connProvider, Configuration configuration, QueryMetadata metadata) {
        super(connProvider, configuration, metadata);
    }

    public C bigResult() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_BIG_RESULT));
    }

    public C bufferResult() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_BUFFER_RESULT));
    }

    public C cache() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_CACHE));
    }

    public C calcFoundRows() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_CALC_FOUND_ROWS));
    }

    public C highPriority() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, HIGH_PRIORITY));
    }

    public C into(String var) {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.END, "\ninto " + var));
    }

    public C intoDumpfile(File file) {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.END, "\ninto dumpfile '" + file.getPath() + "'"));
    }

    public C intoOutfile(File file) {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.END, "\ninto outfile '" + file.getPath() + "'"));
    }

    public C lockInShareMode() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.END, LOCK_IN_SHARE_MODE));
    }

    public C noCache() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_NO_CACHE));
    }

    public C smallResult() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, SQL_SMALL_RESULT));
    }

    public C straightJoin() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_SELECT, STRAIGHT_JOIN));
    }

    public C forceIndex(String ... indexes) {
        return (C)((AbstractMySQLQuery)this.addJoinFlag(" force index (" + String.join((CharSequence)", ", indexes) + ")", JoinFlag.Position.END));
    }

    public C ignoreIndex(String ... indexes) {
        return (C)((AbstractMySQLQuery)this.addJoinFlag(" ignore index (" + String.join((CharSequence)", ", indexes) + ")", JoinFlag.Position.END));
    }

    public C useIndex(String ... indexes) {
        return (C)((AbstractMySQLQuery)this.addJoinFlag(" use index (" + String.join((CharSequence)", ", indexes) + ")", JoinFlag.Position.END));
    }

    public C withRollup() {
        return (C)((AbstractMySQLQuery)this.addFlag(QueryFlag.Position.AFTER_GROUP_BY, WITH_ROLLUP));
    }
}

