/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketListener;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.EstimationProbe;
import io.github.bucket4j.MathType;
import io.github.bucket4j.Nothing;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.TokensInheritanceStrategy;
import io.github.bucket4j.VerboseResult;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.local.LocalBucket;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeBucket
extends AbstractBucket
implements LocalBucket,
ComparableByContent<LockFreeBucket> {
    private final AtomicReference<BucketState> stateRef;
    private final TimeMeter timeMeter;
    public static final SerializationHandle<LockFreeBucket> SERIALIZATION_HANDLE = new SerializationHandle<LockFreeBucket>(){

        @Override
        public <S> LockFreeBucket deserialize(DeserializationAdapter<S> adapter, S input, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = adapter.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            BucketConfiguration bucketConfiguration = BucketConfiguration.SERIALIZATION_HANDLE.deserialize(adapter, input, backwardCompatibilityVersion);
            BucketState bucketState = BucketState.deserialize(adapter, input, backwardCompatibilityVersion);
            bucketState.setConfiguration(bucketConfiguration);
            AtomicReference<BucketState> stateRef = new AtomicReference<BucketState>(bucketState);
            return new LockFreeBucket(stateRef, TimeMeter.SYSTEM_MILLISECONDS, BucketListener.NOPE);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter, O output, LockFreeBucket bucket, Version backwardCompatibilityVersion) throws IOException {
            if (bucket.timeMeter != TimeMeter.SYSTEM_MILLISECONDS) {
                throw new NotSerializableException("Only TimeMeter.SYSTEM_MILLISECONDS can be serialized safely");
            }
            adapter.writeInt(output, Versions.v_7_0_0.getNumber());
            BucketState state = bucket.stateRef.get();
            BucketConfiguration.SERIALIZATION_HANDLE.serialize(adapter, output, state.getConfiguration(), backwardCompatibilityVersion);
            BucketState.serialize(adapter, output, state, backwardCompatibilityVersion);
        }

        @Override
        public int getTypeId() {
            return 60;
        }

        @Override
        public Class<LockFreeBucket> getSerializedType() {
            return LockFreeBucket.class;
        }

        @Override
        public LockFreeBucket fromJsonCompatibleSnapshot(Map<String, Object> snapshot, Version backwardCompatibilityVersion) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            Map stateSnapshot = (Map)snapshot.get("state");
            BucketState state = BucketState.fromJsonCompatibleSnapshot(stateSnapshot, backwardCompatibilityVersion);
            return new LockFreeBucket(new AtomicReference<BucketState>(state), TimeMeter.SYSTEM_MILLISECONDS, BucketListener.NOPE);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(LockFreeBucket bucket, Version backwardCompatibilityVersion) throws IOException {
            if (bucket.timeMeter != TimeMeter.SYSTEM_MILLISECONDS) {
                throw new NotSerializableException("Only TimeMeter.SYSTEM_MILLISECONDS can be serialized safely");
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("state", BucketState.toJsonCompatibleSnapshot(bucket.stateRef.get(), backwardCompatibilityVersion));
            return result;
        }

        @Override
        public String getTypeName() {
            return "LockFreeBucket";
        }
    };

    public LockFreeBucket(BucketConfiguration configuration, MathType mathType, TimeMeter timeMeter) {
        this(new AtomicReference<BucketState>(LockFreeBucket.createStateWithConfiguration(configuration, mathType, timeMeter)), timeMeter, BucketListener.NOPE);
    }

    private LockFreeBucket(AtomicReference<BucketState> stateRef, TimeMeter timeMeter, BucketListener listener) {
        super(listener);
        this.timeMeter = timeMeter;
        this.stateRef = stateRef;
    }

    @Override
    public Bucket toListenable(BucketListener listener) {
        return new LockFreeBucket(this.stateRef, this.timeMeter, listener);
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return 0L;
            }
            newState.consume(toConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return toConsume;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                return false;
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return true;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = newState.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, true);
                long nanosToWaitForReset = newState.calculateFullRefillingTime(currentTimeNanos);
                return ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                long remainingTokens = availableToConsume - tokensToConsume;
                long nanosToWaitForReset = newState.calculateFullRefillingTime(currentTimeNanos);
                return ConsumptionProbe.consumed(remainingTokens, nanosToWaitForReset);
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected EstimationProbe estimateAbilityToConsumeImpl(long tokensToEstimate) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        newState.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = newState.getAvailableTokens();
        if (tokensToEstimate > availableToConsume) {
            long nanosToWaitForRefill = newState.calculateDelayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos, true);
            return EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
        }
        return EstimationProbe.canBeConsumed(availableToConsume);
    }

    @Override
    protected long reserveAndCalculateTimeToSleepImpl(long tokensToConsume, long waitIfBusyNanosLimit) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = newState.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
            if (nanosToCloseDeficit == 0L) {
                newState.consume(tokensToConsume);
                if (this.stateRef.compareAndSet(previousState, newState)) {
                    return 0L;
                }
                previousState = this.stateRef.get();
                newState.copyStateFrom(previousState);
                continue;
            }
            if (nanosToCloseDeficit == Long.MAX_VALUE || nanosToCloseDeficit > waitIfBusyNanosLimit) {
                return Long.MAX_VALUE;
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return nanosToCloseDeficit;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.addTokens(tokensToAdd);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected void forceAddTokensImpl(long tokensToAdd) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.forceAddTokens(tokensToAdd);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    public void reset() {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.reset();
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected void replaceConfigurationImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState = newState.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected long consumeIgnoringRateLimitsImpl(long tokensToConsume) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = newState.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                return nanosToCloseDeficit;
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return nanosToCloseDeficit;
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Long> consumeAsMuchAsPossibleVerboseImpl(long limit) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return new VerboseResult<Long>(currentTimeNanos, 0L, newState);
            }
            newState.consume(toConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Long>(currentTimeNanos, toConsume, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Boolean> tryConsumeVerboseImpl(long tokensToConsume) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                return new VerboseResult<Boolean>(currentTimeNanos, false, newState);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Boolean>(currentTimeNanos, true, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<ConsumptionProbe> tryConsumeAndReturnRemainingTokensVerboseImpl(long tokensToConsume) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens();
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = newState.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, true);
                long nanosToWaitForReset = newState.calculateFullRefillingTime(currentTimeNanos);
                ConsumptionProbe consumptionProbe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill, nanosToWaitForReset);
                return new VerboseResult<ConsumptionProbe>(currentTimeNanos, consumptionProbe, newState);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                long nanosToWaitForReset = newState.calculateFullRefillingTime(currentTimeNanos);
                ConsumptionProbe consumptionProbe = ConsumptionProbe.consumed(availableToConsume - tokensToConsume, nanosToWaitForReset);
                return new VerboseResult<ConsumptionProbe>(currentTimeNanos, consumptionProbe, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<EstimationProbe> estimateAbilityToConsumeVerboseImpl(long tokensToEstimate) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        newState.refillAllBandwidth(currentTimeNanos);
        long availableToConsume = newState.getAvailableTokens();
        if (tokensToEstimate > availableToConsume) {
            long nanosToWaitForRefill = newState.calculateDelayNanosAfterWillBePossibleToConsume(tokensToEstimate, currentTimeNanos, true);
            EstimationProbe estimationProbe = EstimationProbe.canNotBeConsumed(availableToConsume, nanosToWaitForRefill);
            return new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, newState);
        }
        EstimationProbe estimationProbe = EstimationProbe.canBeConsumed(availableToConsume);
        return new VerboseResult<EstimationProbe>(currentTimeNanos, estimationProbe, newState);
    }

    @Override
    protected VerboseResult<Long> getAvailableTokensVerboseImpl() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        BucketState snapshot = this.stateRef.get().copy();
        snapshot.refillAllBandwidth(currentTimeNanos);
        return new VerboseResult<Long>(currentTimeNanos, snapshot.getAvailableTokens(), snapshot);
    }

    @Override
    protected VerboseResult<Nothing> addTokensVerboseImpl(long tokensToAdd) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.addTokens(tokensToAdd);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Nothing> forceAddTokensVerboseImpl(long tokensToAdd) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.forceAddTokens(tokensToAdd);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Nothing> resetVerboseImpl() {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState.reset();
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Nothing>(currentTimeNanos, Nothing.INSTANCE, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Nothing> replaceConfigurationVerboseImpl(BucketConfiguration newConfiguration, TokensInheritanceStrategy tokensInheritanceStrategy) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            newState = newState.replaceConfiguration(newConfiguration, tokensInheritanceStrategy, currentTimeNanos);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Object>(currentTimeNanos, null, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected VerboseResult<Long> consumeIgnoringRateLimitsVerboseImpl(long tokensToConsume) {
        BucketState previousState = this.stateRef.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(currentTimeNanos);
            long nanosToCloseDeficit = newState.calculateDelayNanosAfterWillBePossibleToConsume(tokensToConsume, currentTimeNanos, false);
            if (nanosToCloseDeficit == INFINITY_DURATION) {
                return new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, newState);
            }
            newState.consume(tokensToConsume);
            if (this.stateRef.compareAndSet(previousState, newState)) {
                return new VerboseResult<Long>(currentTimeNanos, nanosToCloseDeficit, newState.copy());
            }
            previousState = this.stateRef.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        BucketState snapshot = this.stateRef.get().copy();
        snapshot.refillAllBandwidth(currentTimeNanos);
        return snapshot.getAvailableTokens();
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.stateRef.get().getConfiguration();
    }

    @Override
    public TimeMeter getTimeMeter() {
        return this.timeMeter;
    }

    @Override
    public SynchronizationStrategy getSynchronizationStrategy() {
        return SynchronizationStrategy.LOCK_FREE;
    }

    private static BucketState createStateWithConfiguration(BucketConfiguration configuration, MathType mathType, TimeMeter timeMeter) {
        return BucketState.createInitialState(configuration, mathType, timeMeter.currentTimeNanos());
    }

    public String toString() {
        BucketState bucketState = this.stateRef.get();
        return "LockFreeBucket{state=" + bucketState + ", configuration=" + bucketState.getConfiguration() + "}";
    }

    @Override
    public boolean equalsByContent(LockFreeBucket other) {
        BucketState otherState;
        BucketState state = this.stateRef.get();
        return ComparableByContent.equals(state, otherState = other.stateRef.get()) && ComparableByContent.equals(state.getConfiguration(), otherState.getConfiguration()) && this.timeMeter == other.timeMeter;
    }
}

