/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.sal.api.permission.PermissionEnforcer;
import com.atlassian.webresource.api.QueryParams;
import com.atlassian.webresource.api.url.UrlBuilder;
import com.atlassian.webresource.spi.condition.UrlReadingCondition;
import com.atlassian.zdu.api.BannerService;
import com.atlassian.zdu.rest.dto.BannerState;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;

public class LoadZduResourcesCondition
implements UrlReadingCondition {
    private static final String ZDU_MODE_QUERY_PARAM = "isZduModeAvailable";
    private final BannerService bannerService;
    private final PermissionEnforcer permissionEnforcer;

    public LoadZduResourcesCondition(@Nonnull PermissionEnforcer permissionEnforcer, @Nonnull BannerService bannerService) {
        this.permissionEnforcer = Objects.requireNonNull(permissionEnforcer);
        this.bannerService = Objects.requireNonNull(bannerService);
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public void addToUrl(UrlBuilder urlBuilder) {
        if (this.isZduBannerVisible()) {
            urlBuilder.addToQueryString(ZDU_MODE_QUERY_PARAM, Boolean.TRUE.toString());
        }
    }

    public boolean shouldDisplay(QueryParams queryParams) {
        return Boolean.parseBoolean(queryParams.get(ZDU_MODE_QUERY_PARAM));
    }

    private boolean isZduBannerVisible() {
        return this.permissionEnforcer.isSystemAdmin() && this.bannerService.getState() != BannerState.HIDDEN;
    }
}

