/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.audit;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.zdu.event.ZduApprovedEvent;
import com.atlassian.zdu.event.ZduCancelledEvent;
import com.atlassian.zdu.event.ZduCompletedEvent;
import com.atlassian.zdu.event.ZduRetryEvent;
import com.atlassian.zdu.event.ZduStartedEvent;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ZduAuditListener {
    private final EventListenerRegistrar eventListenerRegistrar;
    private final AuditService auditService;

    public ZduAuditListener(@Nonnull EventListenerRegistrar eventListenerRegistrar, @Nonnull AuditService auditService) {
        this.eventListenerRegistrar = Objects.requireNonNull(eventListenerRegistrar);
        this.auditService = Objects.requireNonNull(auditService);
    }

    @PostConstruct
    public void subscribe() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    public void unsubscribe() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @EventListener
    public void onZduStarted(ZduStartedEvent ev) {
        this.auditService.audit(AuditEvent.builder((AuditType)ZduAuditTypes.ZDU_STARTED).changedValues(this.changedValues(null, ev.getNodeVersion())).build());
    }

    @EventListener
    public void onZduCancelled(ZduCancelledEvent ev) {
        this.auditService.audit(AuditEvent.builder((AuditType)ZduAuditTypes.ZDU_CANCELLED).changedValues(this.changedValues(ev.getNodeVersion(), ev.getNodeVersion())).build());
    }

    @EventListener
    public void onZduCompleted(ZduCompletedEvent ev) {
        this.auditService.audit(AuditEvent.builder((AuditType)ZduAuditTypes.ZDU_COMPLETED).changedValues(this.changedValues(ev.getFromVersion(), ev.getToVersion())).build());
    }

    @EventListener
    public void onZduRetry(ZduRetryEvent ev) {
        this.auditService.audit(AuditEvent.builder((AuditType)ZduAuditTypes.ZDU_RETRY).changedValues(this.changedValues(ev.getNodeVersion(), ev.getNodeVersion())).build());
    }

    @EventListener
    public void onZduApproved(ZduApprovedEvent ev) {
        this.auditService.audit(AuditEvent.builder((AuditType)ZduAuditTypes.ZDU_APPROVED).changedValues(this.changedValues(ev.getFromVersion(), ev.getToVersion())).build());
    }

    private List<ChangedValue> changedValues(@Nullable String fromVersion, @Nonnull String toVersion) {
        return Collections.singletonList(ChangedValue.fromI18nKeys((String)"zdu.audit.value.version").from(fromVersion).to(toVersion).build());
    }

    @VisibleForTesting
    static class ZduAuditTypes {
        static final AuditType ZDU_STARTED = ZduAuditTypes.auditType("zdu.audit.summary.upgrade.started");
        static final AuditType ZDU_CANCELLED = ZduAuditTypes.auditType("zdu.audit.summary.upgrade.cancelled");
        static final AuditType ZDU_COMPLETED = ZduAuditTypes.auditType("zdu.audit.summary.upgrade.completed");
        static final AuditType ZDU_RETRY = ZduAuditTypes.auditType("zdu.audit.summary.upgrade.retry");
        static final AuditType ZDU_APPROVED = ZduAuditTypes.auditType("zdu.audit.summary.upgrade.approved");

        private ZduAuditTypes() {
        }

        private static AuditType auditType(@Nonnull String summaryKey) {
            return AuditType.fromI18nKeys((CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.ADVANCED, (String)"zdu.audit.category.system", (String)summaryKey).build();
        }
    }

    @VisibleForTesting
    static class I18nKeys {
        static final String CATEGORY = "zdu.audit.category.system";
        static final String VERSION_VALUE = "zdu.audit.value.version";

        private I18nKeys() {
        }
    }
}

