/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.impl;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.zdu.internal.api.NodeInfo;
import com.atlassian.zdu.internal.api.ZduNodeRepositoryService;
import com.atlassian.zdu.persistence.ZduNodeRepository;
import com.atlassian.zdu.rest.dto.NodeInfoDTO;
import java.util.List;

@VisibleForTesting
public class ZduNodeRepositoryServiceImpl
implements ZduNodeRepositoryService {
    private final ZduNodeRepository zduNodeRepository;

    public ZduNodeRepositoryServiceImpl(ZduNodeRepository repository) {
        this.zduNodeRepository = repository;
    }

    public void removeAllNodeInfo() {
        this.zduNodeRepository.cleanAll();
    }

    public void removeNodeInfo(String nodeId) {
        List<NodeInfo> nodes = this.zduNodeRepository.get().stream().filter(n -> !n.getId().equals(nodeId)).toList();
        this.zduNodeRepository.cleanAll();
        this.zduNodeRepository.put(nodes);
    }

    public void addNodeInfo(NodeInfo node) {
        List<NodeInfo> nodes = this.zduNodeRepository.get();
        nodes.add(NodeInfoDTO.builder(node).build());
        this.zduNodeRepository.put(nodes);
    }
}

