/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.time.Instant;

public final class UnixEpochJsonUtils {
    private UnixEpochJsonUtils() {
    }

    public static class Serializer
    extends JsonSerializer<Instant> {
        public void serialize(Instant value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Long.toString(value.toEpochMilli()));
        }
    }

    public static class Deserializer
    extends JsonDeserializer<Instant> {
        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String str = p.getText().trim();
            if (str.chars().allMatch(Character::isDigit)) {
                return Instant.ofEpochMilli(Long.parseLong(str));
            }
            return Instant.parse(str);
        }
    }
}

