/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.rest.dto;

import com.atlassian.zdu.rest.dto.ClusterState;
import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Describes the state of the ZDU banner.", enumAsRef=true)
public enum BannerState {
    HIDDEN,
    UPGRADE_IN_PROGRESS,
    UPGRADE_TASKS_FAILED;


    public static BannerState fromClusterState(ClusterState clusterState) {
        return switch (clusterState) {
            default -> throw new MatchException(null, null);
            case ClusterState.STABLE -> HIDDEN;
            case ClusterState.READY_TO_UPGRADE, ClusterState.MIXED, ClusterState.READY_TO_RUN_UPGRADE_TASKS, ClusterState.RUNNING_UPGRADE_TASKS -> UPGRADE_IN_PROGRESS;
            case ClusterState.UPGRADE_TASKS_FAILED -> UPGRADE_TASKS_FAILED;
        };
    }
}

