/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.rest.dto;

import com.atlassian.zdu.internal.api.NodeInfo;
import com.atlassian.zdu.rest.LinkBuilder;
import com.atlassian.zdu.rest.dto.BannerState;
import com.atlassian.zdu.rest.dto.ClusterState;
import com.atlassian.zdu.rest.dto.Link;
import com.atlassian.zdu.rest.dto.NodeInfoDTO;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

@Schema(description="Represents the state of the Cluster, including all Nodes and its current state.")
@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, creatorVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class Cluster {
    @Schema(description="If true, it's safe to upgrade the nodes of the cluster")
    private final boolean upgradeModeEnabled;
    @Schema(description="If true, there are finalization tasks that need to be run")
    private final boolean hasFinalizationTasks;
    @Schema(description="The current state of the Cluster.")
    private final ClusterState state;
    @Schema(description="The original product version when ZDU was enabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    private final String originalVersion;
    @ArraySchema(arraySchema=@Schema(description="The nodes which form the Cluster."), schema=@Schema(implementation=NodeInfoDTO.class), minItems=1, uniqueItems=true)
    private final List<NodeInfo> nodes;
    @Schema(description="The state of the ZDU banner.")
    private final BannerState bannerState;

    @JsonCreator
    public Cluster(@JsonProperty(value="upgradeModeEnabled") boolean upgradeModeEnabled, @JsonProperty(value="hasFinalizationTasks") boolean hasFinalizationTasks, @Nonnull @JsonProperty(value="state") ClusterState state, @JsonProperty(value="originalVersion") @Nullable String originalVersion, @Nonnull @JsonProperty(value="nodes") @JsonDeserialize(contentAs=NodeInfoDTO.class) List<NodeInfo> nodes, @Nonnull @JsonProperty(value="bannerState") BannerState bannerState) {
        this.upgradeModeEnabled = upgradeModeEnabled;
        this.hasFinalizationTasks = hasFinalizationTasks;
        this.state = Objects.requireNonNull(state);
        this.originalVersion = originalVersion;
        this.nodes = Objects.requireNonNull(nodes);
        this.bannerState = Objects.requireNonNull(bannerState);
    }

    public boolean isUpgradeModeEnabled() {
        return this.upgradeModeEnabled;
    }

    @JsonProperty(value="hasFinalizationTasks")
    public boolean hasFinalizationTasks() {
        return this.hasFinalizationTasks;
    }

    public ClusterState getState() {
        return this.state;
    }

    @JsonInclude
    public String getOriginalVersion() {
        return this.originalVersion;
    }

    @JsonSerialize(contentAs=NodeInfoDTO.class)
    public List<NodeInfo> getNodes() {
        return this.nodes;
    }

    public BannerState getBannerState() {
        return this.bannerState;
    }

    @Schema(description="Hypermedia links")
    @JsonProperty(access=JsonProperty.Access.READ_ONLY)
    public List<Link> getLinks() {
        return LinkBuilder.forCluster(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cluster other = (Cluster)o;
        return this.state == other.state && this.nodes.equals(other.nodes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.nodes});
    }
}

