/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.zdu.rest.dto;

import com.atlassian.zdu.internal.api.NodeInfo;
import com.atlassian.zdu.rest.dto.ClusterState;
import com.atlassian.zdu.rest.dto.NodeInfoDTO;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Objects;

@Schema(description="Represents a Cluster state response including the current state and a specific Node's information.")
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public final class ClusterStateResponse {
    @Schema(description="The current state of the Cluster.")
    @Nonnull
    private final ClusterState state;
    @Schema(description="The responding Node's information and state.", implementation=NodeInfoDTO.class)
    private final NodeInfo buildInfo;

    public ClusterStateResponse(ClusterState state, NodeInfo buildInfo) {
        this.state = Objects.requireNonNull(state);
        this.buildInfo = buildInfo;
    }

    @Schema(description="The current state of the Cluster.")
    @Nonnull
    public ClusterState getState() {
        return this.state;
    }

    @Schema(description="The responding Node's information and state.", implementation=NodeInfoDTO.class)
    public NodeInfo getBuildInfo() {
        return this.buildInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ClusterStateResponse that = (ClusterStateResponse)obj;
        return Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.buildInfo, that.buildInfo);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.buildInfo});
    }

    public String toString() {
        return "ClusterStateResponse[state=" + String.valueOf((Object)this.state) + ", buildInfo=" + String.valueOf(this.buildInfo) + "]";
    }
}

