// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.schemaregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Error response returned from Azure Schema Registry service.
 */
@Fluent
public final class ErrorDetail implements JsonSerializable<ErrorDetail> {
    /*
     * Server-defined error code.
     */
    private String code;

    /*
     * Brief description of error.
     */
    private String message;

    /*
     * Error message details to help user understand/debug failure.
     */
    private List<ErrorDetail> details;

    /**
     * Creates an instance of ErrorDetail class.
     */
    public ErrorDetail() {
    }

    /**
     * Get the code property: Server-defined error code.
     * 
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Set the code property: Server-defined error code.
     * 
     * @param code the code value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Brief description of error.
     * 
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: Brief description of error.
     * 
     * @param message the message value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the details property: Error message details to help user understand/debug failure.
     * 
     * @return the details value.
     */
    public List<ErrorDetail> getDetails() {
        return this.details;
    }

    /**
     * Set the details property: Error message details to help user understand/debug failure.
     * 
     * @param details the details value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setDetails(List<ErrorDetail> details) {
        this.details = details;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ErrorDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ErrorDetail if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ErrorDetail.
     */
    public static ErrorDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ErrorDetail deserializedErrorDetail = new ErrorDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedErrorDetail.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedErrorDetail.message = reader.getString();
                } else if ("details".equals(fieldName)) {
                    List<ErrorDetail> details = reader.readArray(reader1 -> ErrorDetail.fromJson(reader1));
                    deserializedErrorDetail.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedErrorDetail;
        });
    }
}
