// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.schemaregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Object received from the registry containing the list of schema versions and link to next batch page.
 */
@Fluent
public final class SchemaVersions implements JsonSerializable<SchemaVersions> {
    /*
     * Array of schema version integers.
     */
    private List<Integer> versions;

    /*
     * URl to next batch of schema versions
     */
    private String nextLink;

    /**
     * Creates an instance of SchemaVersions class.
     */
    public SchemaVersions() {
    }

    /**
     * Get the versions property: Array of schema version integers.
     * 
     * @return the versions value.
     */
    public List<Integer> getVersions() {
        return this.versions;
    }

    /**
     * Set the versions property: Array of schema version integers.
     * 
     * @param versions the versions value to set.
     * @return the SchemaVersions object itself.
     */
    public SchemaVersions setVersions(List<Integer> versions) {
        this.versions = versions;
        return this;
    }

    /**
     * Get the nextLink property: URl to next batch of schema versions.
     * 
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URl to next batch of schema versions.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SchemaVersions object itself.
     */
    public SchemaVersions setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("schemaVersions", this.versions, (writer, element) -> writer.writeInt(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SchemaVersions from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SchemaVersions if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SchemaVersions.
     */
    public static SchemaVersions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SchemaVersions deserializedSchemaVersions = new SchemaVersions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("schemaVersions".equals(fieldName)) {
                    List<Integer> versions = reader.readArray(reader1 -> reader1.getInt());
                    deserializedSchemaVersions.versions = versions;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSchemaVersions.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSchemaVersions;
        });
    }
}
