/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.schemaregistry.implementation.SchemaGroupsOperationsImpl;
import com.azure.data.schemaregistry.implementation.SchemasImpl;

public final class AzureSchemaRegistryImpl {
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final SchemaGroupsOperationsImpl schemaGroupsOperations;
    private final SchemasImpl schemas;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public SchemaGroupsOperationsImpl getSchemaGroupsOperations() {
        return this.schemaGroupsOperations;
    }

    public SchemasImpl getSchemas() {
        return this.schemas;
    }

    public AzureSchemaRegistryImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    public AzureSchemaRegistryImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    public AzureSchemaRegistryImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.schemaGroupsOperations = new SchemaGroupsOperationsImpl(this);
        this.schemas = new SchemasImpl(this);
    }
}

