/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.SignedIdentifiersWrapper;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.SignedIdentifier;
import com.azure.data.tables.implementation.models.TableEntityQueryResponse;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TableQueryResponse;
import com.azure.data.tables.implementation.models.TableResponse;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.implementation.models.TablesCreateHeaders;
import com.azure.data.tables.implementation.models.TablesDeleteEntityHeaders;
import com.azure.data.tables.implementation.models.TablesDeleteHeaders;
import com.azure.data.tables.implementation.models.TablesGetAccessPolicyHeaders;
import com.azure.data.tables.implementation.models.TablesInsertEntityHeaders;
import com.azure.data.tables.implementation.models.TablesMergeEntityHeaders;
import com.azure.data.tables.implementation.models.TablesQueryEntitiesHeaders;
import com.azure.data.tables.implementation.models.TablesQueryEntityWithPartitionAndRowKeyHeaders;
import com.azure.data.tables.implementation.models.TablesQueryHeaders;
import com.azure.data.tables.implementation.models.TablesSetAccessPolicyHeaders;
import com.azure.data.tables.implementation.models.TablesUpdateEntityHeaders;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class TablesImpl {
    private final TablesService service;
    private final AzureTableImpl client;

    TablesImpl(AzureTableImpl client) {
        this.service = (TablesService)RestProxy.create(TablesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesQueryHeaders, TableQueryResponse>> queryWithResponseAsync(String requestId, String nextTableName, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return FluxUtil.withContext(context -> this.service.query(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, top, select, filter, nextTableName, "application/json;odata=minimalmetadata", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesQueryHeaders, TableQueryResponse>> queryWithResponseAsync(String requestId, String nextTableName, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.query(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, top, select, filter, nextTableName, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableQueryResponse> queryAsync(String requestId, String nextTableName, QueryOptions queryOptions) {
        return this.queryWithResponseAsync(requestId, nextTableName, queryOptions).flatMap(res -> Mono.justOrEmpty((Object)((TableQueryResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableQueryResponse> queryAsync(String requestId, String nextTableName, QueryOptions queryOptions, Context context) {
        return this.queryWithResponseAsync(requestId, nextTableName, queryOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((TableQueryResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesQueryHeaders, TableQueryResponse> queryWithResponse(String requestId, String nextTableName, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.querySync(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, top, select, filter, nextTableName, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableQueryResponse query(String requestId, String nextTableName, QueryOptions queryOptions) {
        return (TableQueryResponse)this.queryWithResponse(requestId, nextTableName, queryOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesCreateHeaders, TableResponse>> createWithResponseAsync(TableProperties tableProperties, String requestId, ResponseFormat responsePreference, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return FluxUtil.withContext(context -> this.service.create(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, responsePreference, tableProperties, "application/json;odata=minimalmetadata", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesCreateHeaders, TableResponse>> createWithResponseAsync(TableProperties tableProperties, String requestId, ResponseFormat responsePreference, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.create(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, responsePreference, tableProperties, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableResponse> createAsync(TableProperties tableProperties, String requestId, ResponseFormat responsePreference, QueryOptions queryOptions) {
        return this.createWithResponseAsync(tableProperties, requestId, responsePreference, queryOptions).flatMap(res -> Mono.justOrEmpty((Object)((TableResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableResponse> createAsync(TableProperties tableProperties, String requestId, ResponseFormat responsePreference, QueryOptions queryOptions, Context context) {
        return this.createWithResponseAsync(tableProperties, requestId, responsePreference, queryOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((TableResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesCreateHeaders, TableResponse> createWithResponse(TableProperties tableProperties, String requestId, ResponseFormat responsePreference, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.createSync(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, responsePreference, tableProperties, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableResponse create(TableProperties tableProperties, String requestId, ResponseFormat responsePreference, QueryOptions queryOptions) {
        return (TableResponse)this.createWithResponse(tableProperties, requestId, responsePreference, queryOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesDeleteHeaders, Void>> deleteWithResponseAsync(String table, String requestId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getUrl(), this.client.getVersion(), requestId, table, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesDeleteHeaders, Void>> deleteWithResponseAsync(String table, String requestId, Context context) {
        String accept = "application/json";
        return this.service.delete(this.client.getUrl(), this.client.getVersion(), requestId, table, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String table, String requestId) {
        return this.deleteWithResponseAsync(table, requestId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String table, String requestId, Context context) {
        return this.deleteWithResponseAsync(table, requestId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesDeleteHeaders, Void> deleteWithResponse(String table, String requestId, Context context) {
        String accept = "application/json";
        return this.service.deleteSync(this.client.getUrl(), this.client.getVersion(), requestId, table, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String table, String requestId) {
        this.deleteWithResponse(table, requestId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesQueryEntitiesHeaders, TableEntityQueryResponse>> queryEntitiesWithResponseAsync(String table, Integer timeout, String requestId, String nextPartitionKey, String nextRowKey, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return FluxUtil.withContext(context -> this.service.queryEntities(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, top, select, filter, table, nextPartitionKey, nextRowKey, "application/json;odata=minimalmetadata", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesQueryEntitiesHeaders, TableEntityQueryResponse>> queryEntitiesWithResponseAsync(String table, Integer timeout, String requestId, String nextPartitionKey, String nextRowKey, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.queryEntities(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, top, select, filter, table, nextPartitionKey, nextRowKey, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableEntityQueryResponse> queryEntitiesAsync(String table, Integer timeout, String requestId, String nextPartitionKey, String nextRowKey, QueryOptions queryOptions) {
        return this.queryEntitiesWithResponseAsync(table, timeout, requestId, nextPartitionKey, nextRowKey, queryOptions).flatMap(res -> Mono.justOrEmpty((Object)((TableEntityQueryResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TableEntityQueryResponse> queryEntitiesAsync(String table, Integer timeout, String requestId, String nextPartitionKey, String nextRowKey, QueryOptions queryOptions, Context context) {
        return this.queryEntitiesWithResponseAsync(table, timeout, requestId, nextPartitionKey, nextRowKey, queryOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((TableEntityQueryResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesQueryEntitiesHeaders, TableEntityQueryResponse> queryEntitiesWithResponse(String table, Integer timeout, String requestId, String nextPartitionKey, String nextRowKey, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.queryEntitiesSync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, top, select, filter, table, nextPartitionKey, nextRowKey, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TableEntityQueryResponse queryEntities(String table, Integer timeout, String requestId, String nextPartitionKey, String nextRowKey, QueryOptions queryOptions) {
        return (TableEntityQueryResponse)this.queryEntitiesWithResponse(table, timeout, requestId, nextPartitionKey, nextRowKey, queryOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesQueryEntityWithPartitionAndRowKeyHeaders, Map<String, Object>>> queryEntityWithPartitionAndRowKeyWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return FluxUtil.withContext(context -> this.service.queryEntityWithPartitionAndRowKey(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, select, filter, table, partitionKey, rowKey, "application/json;odata=minimalmetadata", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesQueryEntityWithPartitionAndRowKeyHeaders, Map<String, Object>>> queryEntityWithPartitionAndRowKeyWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.queryEntityWithPartitionAndRowKey(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, select, filter, table, partitionKey, rowKey, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> queryEntityWithPartitionAndRowKeyAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, QueryOptions queryOptions) {
        return this.queryEntityWithPartitionAndRowKeyWithResponseAsync(table, partitionKey, rowKey, timeout, requestId, queryOptions).flatMap(res -> Mono.justOrEmpty((Object)((Map)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> queryEntityWithPartitionAndRowKeyAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        return this.queryEntityWithPartitionAndRowKeyWithResponseAsync(table, partitionKey, rowKey, timeout, requestId, queryOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((Map)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesQueryEntityWithPartitionAndRowKeyHeaders, Map<String, Object>> queryEntityWithPartitionAndRowKeyWithResponse(String table, String partitionKey, String rowKey, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.queryEntityWithPartitionAndRowKeySync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, select, filter, table, partitionKey, rowKey, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> queryEntityWithPartitionAndRowKey(String table, String partitionKey, String rowKey, Integer timeout, String requestId, QueryOptions queryOptions) {
        return (Map)this.queryEntityWithPartitionAndRowKeyWithResponse(table, partitionKey, rowKey, timeout, requestId, queryOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesUpdateEntityHeaders, Void>> updateEntityWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return FluxUtil.withContext(context -> this.service.updateEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesUpdateEntityHeaders, Void>> updateEntityWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.updateEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateEntityAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        return this.updateEntityWithResponseAsync(table, partitionKey, rowKey, timeout, requestId, ifMatch, tableEntityProperties, queryOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateEntityAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        return this.updateEntityWithResponseAsync(table, partitionKey, rowKey, timeout, requestId, ifMatch, tableEntityProperties, queryOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesUpdateEntityHeaders, Void> updateEntityWithResponse(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.updateEntitySync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateEntity(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        this.updateEntityWithResponse(table, partitionKey, rowKey, timeout, requestId, ifMatch, tableEntityProperties, queryOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesMergeEntityHeaders, Void>> mergeEntityWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return FluxUtil.withContext(context -> this.service.mergeEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesMergeEntityHeaders, Void>> mergeEntityWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.mergeEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> mergeEntityAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        return this.mergeEntityWithResponseAsync(table, partitionKey, rowKey, timeout, requestId, ifMatch, tableEntityProperties, queryOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> mergeEntityAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        return this.mergeEntityWithResponseAsync(table, partitionKey, rowKey, timeout, requestId, ifMatch, tableEntityProperties, queryOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesMergeEntityHeaders, Void> mergeEntityWithResponse(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.mergeEntitySync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void mergeEntity(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        this.mergeEntityWithResponse(table, partitionKey, rowKey, timeout, requestId, ifMatch, tableEntityProperties, queryOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesDeleteEntityHeaders, Void>> deleteEntityWithResponseAsync(String table, String partitionKey, String rowKey, String ifMatch, Integer timeout, String requestId, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return FluxUtil.withContext(context -> this.service.deleteEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, "application/json;odata=minimalmetadata", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesDeleteEntityHeaders, Void>> deleteEntityWithResponseAsync(String table, String partitionKey, String rowKey, String ifMatch, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.deleteEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteEntityAsync(String table, String partitionKey, String rowKey, String ifMatch, Integer timeout, String requestId, QueryOptions queryOptions) {
        return this.deleteEntityWithResponseAsync(table, partitionKey, rowKey, ifMatch, timeout, requestId, queryOptions).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteEntityAsync(String table, String partitionKey, String rowKey, String ifMatch, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        return this.deleteEntityWithResponseAsync(table, partitionKey, rowKey, ifMatch, timeout, requestId, queryOptions, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesDeleteEntityHeaders, Void> deleteEntityWithResponse(String table, String partitionKey, String rowKey, String ifMatch, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.deleteEntitySync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteEntity(String table, String partitionKey, String rowKey, String ifMatch, Integer timeout, String requestId, QueryOptions queryOptions) {
        this.deleteEntityWithResponse(table, partitionKey, rowKey, ifMatch, timeout, requestId, queryOptions, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesInsertEntityHeaders, Map<String, Object>>> insertEntityWithResponseAsync(String table, Integer timeout, String requestId, ResponseFormat responsePreference, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return FluxUtil.withContext(context -> this.service.insertEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, responsePreference, tableEntityProperties, "application/json;odata=minimalmetadata", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesInsertEntityHeaders, Map<String, Object>>> insertEntityWithResponseAsync(String table, Integer timeout, String requestId, ResponseFormat responsePreference, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.insertEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, responsePreference, tableEntityProperties, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> insertEntityAsync(String table, Integer timeout, String requestId, ResponseFormat responsePreference, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        return this.insertEntityWithResponseAsync(table, timeout, requestId, responsePreference, tableEntityProperties, queryOptions).flatMap(res -> Mono.justOrEmpty((Object)((Map)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Map<String, Object>> insertEntityAsync(String table, Integer timeout, String requestId, ResponseFormat responsePreference, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        return this.insertEntityWithResponseAsync(table, timeout, requestId, responsePreference, tableEntityProperties, queryOptions, context).flatMap(res -> Mono.justOrEmpty((Object)((Map)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesInsertEntityHeaders, Map<String, Object>> insertEntityWithResponse(String table, Integer timeout, String requestId, ResponseFormat responsePreference, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.insertEntitySync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, responsePreference, tableEntityProperties, "application/json;odata=minimalmetadata", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Map<String, Object> insertEntity(String table, Integer timeout, String requestId, ResponseFormat responsePreference, Map<String, Object> tableEntityProperties, QueryOptions queryOptions) {
        return (Map)this.insertEntityWithResponse(table, timeout, requestId, responsePreference, tableEntityProperties, queryOptions, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesGetAccessPolicyHeaders, List<SignedIdentifier>>> getAccessPolicyWithResponseAsync(String table, Integer timeout, String requestId) {
        String comp = "acl";
        String accept = "application/xml";
        return FluxUtil.withContext(context -> this.service.getAccessPolicy(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesGetAccessPolicyHeaders, List<SignedIdentifier>>> getAccessPolicyWithResponseAsync(String table, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<SignedIdentifier>> getAccessPolicyAsync(String table, Integer timeout, String requestId) {
        return this.getAccessPolicyWithResponseAsync(table, timeout, requestId).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<List<SignedIdentifier>> getAccessPolicyAsync(String table, Integer timeout, String requestId, Context context) {
        return this.getAccessPolicyWithResponseAsync(table, timeout, requestId, context).flatMap(res -> Mono.justOrEmpty((Object)((List)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesGetAccessPolicyHeaders, List<SignedIdentifier>> getAccessPolicyWithResponse(String table, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicySync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public List<SignedIdentifier> getAccessPolicy(String table, Integer timeout, String requestId) {
        return (List)this.getAccessPolicyWithResponse(table, timeout, requestId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String table, Integer timeout, String requestId, List<SignedIdentifier> tableAcl) {
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper tableAclConverted = new SignedIdentifiersWrapper(tableAcl);
        return FluxUtil.withContext(context -> this.service.setAccessPolicy(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", tableAclConverted, "application/xml", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<TablesSetAccessPolicyHeaders, Void>> setAccessPolicyWithResponseAsync(String table, Integer timeout, String requestId, List<SignedIdentifier> tableAcl, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper tableAclConverted = new SignedIdentifiersWrapper(tableAcl);
        return this.service.setAccessPolicy(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", tableAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String table, Integer timeout, String requestId, List<SignedIdentifier> tableAcl) {
        return this.setAccessPolicyWithResponseAsync(table, timeout, requestId, tableAcl).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> setAccessPolicyAsync(String table, Integer timeout, String requestId, List<SignedIdentifier> tableAcl, Context context) {
        return this.setAccessPolicyWithResponseAsync(table, timeout, requestId, tableAcl, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ResponseBase<TablesSetAccessPolicyHeaders, Void> setAccessPolicyWithResponse(String table, Integer timeout, String requestId, List<SignedIdentifier> tableAcl, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        SignedIdentifiersWrapper tableAclConverted = new SignedIdentifiersWrapper(tableAcl);
        return this.service.setAccessPolicySync(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", tableAclConverted, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void setAccessPolicy(String table, Integer timeout, String requestId, List<SignedIdentifier> tableAcl) {
        this.setAccessPolicyWithResponse(table, timeout, requestId, tableAcl, Context.NONE);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureTableTables")
    public static interface TablesService {
        @Get(value="/Tables")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<ResponseBase<TablesQueryHeaders, TableQueryResponse>> query(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @HeaderParam(value="DataServiceVersion") String var4, @QueryParam(value="$format") OdataMetadataFormat var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$select") String var7, @QueryParam(value="$filter") String var8, @QueryParam(value="NextTableName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/Tables")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public ResponseBase<TablesQueryHeaders, TableQueryResponse> querySync(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @HeaderParam(value="DataServiceVersion") String var4, @QueryParam(value="$format") OdataMetadataFormat var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$select") String var7, @QueryParam(value="$filter") String var8, @QueryParam(value="NextTableName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/Tables")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesCreateHeaders, TableResponse>> create(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @HeaderParam(value="DataServiceVersion") String var4, @QueryParam(value="$format") OdataMetadataFormat var5, @HeaderParam(value="Prefer") ResponseFormat var6, @BodyParam(value="application/json;odata=nometadata") TableProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/Tables")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesCreateHeaders, TableResponse> createSync(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @HeaderParam(value="DataServiceVersion") String var4, @QueryParam(value="$format") OdataMetadataFormat var5, @HeaderParam(value="Prefer") ResponseFormat var6, @BodyParam(value="application/json;odata=nometadata") TableProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/Tables('{table}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesDeleteHeaders, Void>> delete(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @PathParam(value="table") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/Tables('{table}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesDeleteHeaders, Void> deleteSync(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @PathParam(value="table") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{table}()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesQueryEntitiesHeaders, TableEntityQueryResponse>> queryEntities(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$select") String var8, @QueryParam(value="$filter") String var9, @PathParam(value="table") String var10, @QueryParam(value="NextPartitionKey") String var11, @QueryParam(value="NextRowKey") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{table}()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesQueryEntitiesHeaders, TableEntityQueryResponse> queryEntitiesSync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$select") String var8, @QueryParam(value="$filter") String var9, @PathParam(value="table") String var10, @QueryParam(value="NextPartitionKey") String var11, @QueryParam(value="NextRowKey") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesQueryEntityWithPartitionAndRowKeyHeaders, Map<String, Object>>> queryEntityWithPartitionAndRowKey(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @QueryParam(value="$select") String var7, @QueryParam(value="$filter") String var8, @PathParam(value="table") String var9, @PathParam(value="partitionKey") String var10, @PathParam(value="rowKey") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Get(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesQueryEntityWithPartitionAndRowKeyHeaders, Map<String, Object>> queryEntityWithPartitionAndRowKeySync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @QueryParam(value="$select") String var7, @QueryParam(value="$filter") String var8, @PathParam(value="table") String var9, @PathParam(value="partitionKey") String var10, @PathParam(value="rowKey") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesUpdateEntityHeaders, Void>> updateEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesUpdateEntityHeaders, Void> updateEntitySync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Patch(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesMergeEntityHeaders, Void>> mergeEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Patch(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesMergeEntityHeaders, Void> mergeEntitySync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Delete(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesDeleteEntityHeaders, Void>> deleteEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Delete(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesDeleteEntityHeaders, Void> deleteEntitySync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/{table}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesInsertEntityHeaders, Map<String, Object>>> insertEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @HeaderParam(value="Prefer") ResponseFormat var8, @BodyParam(value="application/json;odata=nometadata") Map<String, Object> var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/{table}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesInsertEntityHeaders, Map<String, Object>> insertEntitySync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @HeaderParam(value="Prefer") ResponseFormat var8, @BodyParam(value="application/json;odata=nometadata") Map<String, Object> var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{table}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesGetAccessPolicyHeaders, List<SignedIdentifier>>> getAccessPolicy(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @PathParam(value="table") String var5, @QueryParam(value="comp") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Get(value="/{table}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesGetAccessPolicyHeaders, List<SignedIdentifier>> getAccessPolicySync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @PathParam(value="table") String var5, @QueryParam(value="comp") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{table}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<ResponseBase<TablesSetAccessPolicyHeaders, Void>> setAccessPolicy(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @PathParam(value="table") String var5, @QueryParam(value="comp") String var6, @BodyParam(value="application/xml") SignedIdentifiersWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/{table}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public ResponseBase<TablesSetAccessPolicyHeaders, Void> setAccessPolicySync(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @PathParam(value="table") String var5, @QueryParam(value="comp") String var6, @BodyParam(value="application/xml") SignedIdentifiersWrapper var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

