// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.
package com.azure.messaging.servicebus.administration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;

/** Response from listing Service Bus topics. */
@JacksonXmlRootElement(localName = "feed", namespace = "http://www.w3.org/2005/Atom")
@Fluent
public final class TopicDescriptionFeedImpl {

    /*
     * URL of the list topics query.
     */
    @JacksonXmlProperty(localName = "id", namespace = "http://www.w3.org/2005/Atom")
    private String id;

    /*
     * The entity type for the feed.
     */
    @JacksonXmlProperty(localName = "title", namespace = "http://www.w3.org/2005/Atom")
    private TitleImpl title;

    /*
     * Datetime of the query.
     */
    @JacksonXmlProperty(localName = "updated", namespace = "http://www.w3.org/2005/Atom")
    private OffsetDateTime updated;

    /*
     * Links to paginated response.
     */
    @JsonProperty("link")
    private List<ResponseLinkImpl> link = new ArrayList<>();

    /*
     * Topic entries.
     */
    @JsonProperty("entry")
    private List<TopicDescriptionEntryImpl> entry = new ArrayList<>();

    /** Creates an instance of TopicDescriptionFeed class. */
    public TopicDescriptionFeedImpl() {}

    /**
     * Get the id property: URL of the list topics query.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: URL of the list topics query.
     *
     * @param id the id value to set.
     * @return the TopicDescriptionFeed object itself.
     */
    public TopicDescriptionFeedImpl setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the title property: The entity type for the feed.
     *
     * @return the title value.
     */
    public TitleImpl getTitle() {
        return this.title;
    }

    /**
     * Set the title property: The entity type for the feed.
     *
     * @param title the title value to set.
     * @return the TopicDescriptionFeed object itself.
     */
    public TopicDescriptionFeedImpl setTitle(TitleImpl title) {
        this.title = title;
        return this;
    }

    /**
     * Get the updated property: Datetime of the query.
     *
     * @return the updated value.
     */
    public OffsetDateTime getUpdated() {
        return this.updated;
    }

    /**
     * Set the updated property: Datetime of the query.
     *
     * @param updated the updated value to set.
     * @return the TopicDescriptionFeed object itself.
     */
    public TopicDescriptionFeedImpl setUpdated(OffsetDateTime updated) {
        this.updated = updated;
        return this;
    }

    /**
     * Get the link property: Links to paginated response.
     *
     * @return the link value.
     */
    public List<ResponseLinkImpl> getLink() {
        return this.link;
    }

    /**
     * Set the link property: Links to paginated response.
     *
     * @param link the link value to set.
     * @return the TopicDescriptionFeed object itself.
     */
    public TopicDescriptionFeedImpl setLink(List<ResponseLinkImpl> link) {
        this.link = link;
        return this;
    }

    /**
     * Get the entry property: Topic entries.
     *
     * @return the entry value.
     */
    public List<TopicDescriptionEntryImpl> getEntry() {
        return this.entry;
    }

    /**
     * Set the entry property: Topic entries.
     *
     * @param entry the entry value to set.
     * @return the TopicDescriptionFeed object itself.
     */
    public TopicDescriptionFeedImpl setEntry(List<TopicDescriptionEntryImpl> entry) {
        this.entry = entry;
        return this;
    }
}
