// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.monitor.query.implementation.logs.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Functions are stored Kusto queries that can be specified as part of queries by using their name. */
@Fluent
public final class MetadataFunction {
    /*
     * The ID of the function.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /*
     * The name of the function, to be used in queries.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The parameters/arguments of the function, if any.
     */
    @JsonProperty(value = "parameters")
    private String parameters;

    /*
     * The display name of the function.
     */
    @JsonProperty(value = "displayName")
    private String displayName;

    /*
     * The description of the function.
     */
    @JsonProperty(value = "description")
    private String description;

    /*
     * The KQL body of the function.
     */
    @JsonProperty(value = "body", required = true)
    private String body;

    /*
     * The tags associated with the function.
     */
    @JsonProperty(value = "tags")
    private Object tags;

    /*
     * The properties of the function.
     */
    @JsonProperty(value = "properties")
    private Object properties;

    /*
     * The related metadata items for the function.
     */
    @JsonProperty(value = "related")
    private MetadataFunctionRelated related;

    /**
     * Creates an instance of MetadataFunction class.
     *
     * @param id the id value to set.
     * @param name the name value to set.
     * @param body the body value to set.
     */
    @JsonCreator
    public MetadataFunction(
            @JsonProperty(value = "id", required = true) String id,
            @JsonProperty(value = "name", required = true) String name,
            @JsonProperty(value = "body", required = true) String body) {
        this.id = id;
        this.name = name;
        this.body = body;
    }

    /**
     * Get the id property: The ID of the function.
     *
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Get the name property: The name of the function, to be used in queries.
     *
     * @return the name value.
     */
    public String getName() {
        return this.name;
    }

    /**
     * Get the parameters property: The parameters/arguments of the function, if any.
     *
     * @return the parameters value.
     */
    public String getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters/arguments of the function, if any.
     *
     * @param parameters the parameters value to set.
     * @return the MetadataFunction object itself.
     */
    public MetadataFunction setParameters(String parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Get the displayName property: The display name of the function.
     *
     * @return the displayName value.
     */
    public String getDisplayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: The display name of the function.
     *
     * @param displayName the displayName value to set.
     * @return the MetadataFunction object itself.
     */
    public MetadataFunction setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the description property: The description of the function.
     *
     * @return the description value.
     */
    public String getDescription() {
        return this.description;
    }

    /**
     * Set the description property: The description of the function.
     *
     * @param description the description value to set.
     * @return the MetadataFunction object itself.
     */
    public MetadataFunction setDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the body property: The KQL body of the function.
     *
     * @return the body value.
     */
    public String getBody() {
        return this.body;
    }

    /**
     * Get the tags property: The tags associated with the function.
     *
     * @return the tags value.
     */
    public Object getTags() {
        return this.tags;
    }

    /**
     * Set the tags property: The tags associated with the function.
     *
     * @param tags the tags value to set.
     * @return the MetadataFunction object itself.
     */
    public MetadataFunction setTags(Object tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the properties property: The properties of the function.
     *
     * @return the properties value.
     */
    public Object getProperties() {
        return this.properties;
    }

    /**
     * Set the properties property: The properties of the function.
     *
     * @param properties the properties value to set.
     * @return the MetadataFunction object itself.
     */
    public MetadataFunction setProperties(Object properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the related property: The related metadata items for the function.
     *
     * @return the related value.
     */
    public MetadataFunctionRelated getRelated() {
        return this.related;
    }

    /**
     * Set the related property: The related metadata items for the function.
     *
     * @param related the related value to set.
     * @return the MetadataFunction object itself.
     */
    public MetadataFunction setRelated(MetadataFunctionRelated related) {
        this.related = related;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (getId() == null) {
            throw new IllegalArgumentException("Missing required property id in model MetadataFunction");
        }
        if (getName() == null) {
            throw new IllegalArgumentException("Missing required property name in model MetadataFunction");
        }
        if (getBody() == null) {
            throw new IllegalArgumentException("Missing required property body in model MetadataFunction");
        }
        if (getRelated() != null) {
            getRelated().validate();
        }
    }
}
