/*
 * Decompiled with CFR 0.152.
 */
package com.azure.monitor.query;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.monitor.query.LogsQueryAsyncClient;
import com.azure.monitor.query.LogsQueryClientBuilder;
import com.azure.monitor.query.implementation.logs.models.LogsQueryHelper;
import com.azure.monitor.query.models.LogsBatchQuery;
import com.azure.monitor.query.models.LogsBatchQueryResultCollection;
import com.azure.monitor.query.models.LogsQueryOptions;
import com.azure.monitor.query.models.LogsQueryResult;
import com.azure.monitor.query.models.QueryTimeInterval;
import java.util.List;

@ServiceClient(builder=LogsQueryClientBuilder.class)
public final class LogsQueryClient {
    private final LogsQueryAsyncClient asyncClient;

    LogsQueryClient(LogsQueryAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogsQueryResult queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval) {
        return (LogsQueryResult)this.asyncClient.queryWorkspace(workspaceId, query, timeInterval).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> List<T> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type) {
        LogsQueryResult logsQueryResult = (LogsQueryResult)this.asyncClient.queryWorkspace(workspaceId, query, timeInterval).block();
        if (logsQueryResult != null) {
            return LogsQueryHelper.toObject(logsQueryResult.getTable(), type);
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> List<T> queryWorkspace(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options) {
        LogsQueryResult logsQueryResult = (LogsQueryResult)this.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, Context.NONE).getValue();
        if (logsQueryResult != null) {
            return LogsQueryHelper.toObject(logsQueryResult.getTable(), type);
        }
        return null;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogsQueryResult> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, LogsQueryOptions options, Context context) {
        return (Response)this.asyncClient.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public <T> Response<List<T>> queryWorkspaceWithResponse(String workspaceId, String query, QueryTimeInterval timeInterval, Class<T> type, LogsQueryOptions options, Context context) {
        return (Response)this.asyncClient.queryWorkspaceWithResponse(workspaceId, query, timeInterval, options, context).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), LogsQueryHelper.toObject(((LogsQueryResult)response.getValue()).getTable(), type))).block();
    }

    LogsBatchQueryResultCollection queryBatch(String workspaceId, List<String> queries, QueryTimeInterval timeInterval) {
        return (LogsBatchQueryResultCollection)this.asyncClient.queryBatch(workspaceId, queries, timeInterval).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LogsBatchQueryResultCollection queryBatch(LogsBatchQuery logsBatchQuery) {
        return (LogsBatchQueryResultCollection)this.asyncClient.queryBatch(logsBatchQuery).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LogsBatchQueryResultCollection> queryBatchWithResponse(LogsBatchQuery logsBatchQuery, Context context) {
        return (Response)this.asyncClient.queryBatchWithResponse(logsBatchQuery, context).block();
    }
}

